{-|
Module      : Graph.Clustering
Description : Basic tests to avoid quick regression
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}


module Test.Graph.Clustering where

import Gargantext.API.Ngrams.Types (NgramsTerm(..))
import Gargantext.Core.Viz.Graph
import Gargantext.Core.Viz.Graph.Types
import Gargantext.Core.Viz.Graph.Tools (doSimilarityMap)
import Gargantext.Core.Viz.Graph.Tools.IGraph (spinglass)
import Gargantext.Prelude
import Test.Hspec
import Data.HashMap.Strict (HashMap)
import qualified Data.HashMap.Strict as HashMap
import qualified Data.List as List
import Gargantext.Core.Viz.Graph.Tools.IGraph (spinglass)
import Gargantext.Core.Methods.Similarities (Similarity(..))

myCooc :: HashMap (NgramsTerm, NgramsTerm) Int
myCooc = HashMap.fromList [((NgramsTerm {unNgramsTerm = "gev au"},NgramsTerm {unNgramsTerm = "sqrt"}),12),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "data"}),8),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "transverse momentum"}),6),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "gev au"}),7),((NgramsTerm {unNgramsTerm = "d"},NgramsTerm {unNgramsTerm = "rhic"}),13),((NgramsTerm {unNgramsTerm = "p"},NgramsTerm {unNgramsTerm = "sqrt"}),27),((NgramsTerm {unNgramsTerm = "pi ^"},NgramsTerm {unNgramsTerm = "s"}),8),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "p"}),27),((NgramsTerm {unNgramsTerm = "central au"},NgramsTerm {unNgramsTerm = "s"}),10),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "relativistic heavy ion collider"}),5),((NgramsTerm {unNgramsTerm = "eta"},NgramsTerm {unNgramsTerm = "gev"}),9),((NgramsTerm {unNgramsTerm = "phi"},NgramsTerm {unNgramsTerm = "transverse momentum"}),3),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "hadrons"}),4),((NgramsTerm {unNgramsTerm = "data"},NgramsTerm {unNgramsTerm = "gev"}),9),((NgramsTerm {unNgramsTerm = "d"},NgramsTerm {unNgramsTerm = "gev/c"}),3),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "nn"}),80),((NgramsTerm {unNgramsTerm = "p"},NgramsTerm {unNgramsTerm = "particle"}),3),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "p collisions"}),6),((NgramsTerm {unNgramsTerm = "nn"},NgramsTerm {unNgramsTerm = "sqrt"}),88),((NgramsTerm {unNgramsTerm = "centrality dependence"},NgramsTerm {unNgramsTerm = "gev/c"}),5),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "gev au"}),5),((NgramsTerm {unNgramsTerm = "central au"},NgramsTerm {unNgramsTerm = "p_t"}),5),((NgramsTerm {unNgramsTerm = "relativistic heavy ion collider"},NgramsTerm {unNgramsTerm = "sqrt"}),10),((NgramsTerm {unNgramsTerm = "rhic"},NgramsTerm {unNgramsTerm = "s_nn"}),12),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "p"}),21),((NgramsTerm {unNgramsTerm = "data"},NgramsTerm {unNgramsTerm = "sqrt"}),6),((NgramsTerm {unNgramsTerm = "au-au collisions"},NgramsTerm {unNgramsTerm = "gev"}),12),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "relativistic heavy ion collider"}),8),((NgramsTerm {unNgramsTerm = "centrality dependence"},NgramsTerm {unNgramsTerm = "rhic"}),3),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "eta"}),4),((NgramsTerm {unNgramsTerm = "eta"},NgramsTerm {unNgramsTerm = "sqrt"}),9),((NgramsTerm {unNgramsTerm = "nn"},NgramsTerm {unNgramsTerm = "particle"}),8),((NgramsTerm {unNgramsTerm = "au-au collisions"},NgramsTerm {unNgramsTerm = "sqrt"}),10),((NgramsTerm {unNgramsTerm = "gev/c"},NgramsTerm {unNgramsTerm = "s_nn"}),12),((NgramsTerm {unNgramsTerm = "data"},NgramsTerm {unNgramsTerm = "particle"}),4),((NgramsTerm {unNgramsTerm = "central au"},NgramsTerm {unNgramsTerm = "phenix experiment"}),4),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "nn"}),65),((NgramsTerm {unNgramsTerm = "mid-rapidity"},NgramsTerm {unNgramsTerm = "number"}),3),((NgramsTerm {unNgramsTerm = "p_t"},NgramsTerm {unNgramsTerm = "s_nn"}),11),((NgramsTerm {unNgramsTerm = "d"},NgramsTerm {unNgramsTerm = "not found"}),7),((NgramsTerm {unNgramsTerm = "d"},NgramsTerm {unNgramsTerm = "number"}),4),((NgramsTerm {unNgramsTerm = "nn"},NgramsTerm {unNgramsTerm = "pi ^"}),7),((NgramsTerm {unNgramsTerm = "hadrons"},NgramsTerm {unNgramsTerm = "spectra"}),3),((NgramsTerm {unNgramsTerm = "d"},NgramsTerm {unNgramsTerm = "s"}),9),((NgramsTerm {unNgramsTerm = "second part"},NgramsTerm {unNgramsTerm = "thesis"}),4),((NgramsTerm {unNgramsTerm = "eta"},NgramsTerm {unNgramsTerm = "pi ^"}),5),((NgramsTerm {unNgramsTerm = "midrapidity"},NgramsTerm {unNgramsTerm = "p collisions"}),3),((NgramsTerm {unNgramsTerm = "phenix experiment"},NgramsTerm {unNgramsTerm = "s_nn"}),13),((NgramsTerm {unNgramsTerm = "number"},NgramsTerm {unNgramsTerm = "s_nn"}),5),((NgramsTerm {unNgramsTerm = "nuclear modification factors"},NgramsTerm {unNgramsTerm = "p collisions"}),3),((NgramsTerm {unNgramsTerm = "centrality dependence"},NgramsTerm {unNgramsTerm = "number"}),4),((NgramsTerm {unNgramsTerm = "centrality dependence"},NgramsTerm {unNgramsTerm = "s"}),8),((NgramsTerm {unNgramsTerm = "mid-rapidity"},NgramsTerm {unNgramsTerm = "p"}),6),((NgramsTerm {unNgramsTerm = "lambda"},NgramsTerm {unNgramsTerm = "rhic"}),4),((NgramsTerm {unNgramsTerm = "p"},NgramsTerm {unNgramsTerm = "pi ^"}),13),((NgramsTerm {unNgramsTerm = "lambda"},NgramsTerm {unNgramsTerm = "p"}),3),((NgramsTerm {unNgramsTerm = "gev au"},NgramsTerm {unNgramsTerm = "pi ^"}),3),((NgramsTerm {unNgramsTerm = "central au"},NgramsTerm {unNgramsTerm = "nn"}),10),((NgramsTerm {unNgramsTerm = "gev/c"},NgramsTerm {unNgramsTerm = "mid-rapidity"}),7),((NgramsTerm {unNgramsTerm = "d"},NgramsTerm {unNgramsTerm = "p_t"}),3),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "yields"}),7),((NgramsTerm {unNgramsTerm = "d"},NgramsTerm {unNgramsTerm = "phenix experiment"}),9),((NgramsTerm {unNgramsTerm = "mid-rapidity"},NgramsTerm {unNgramsTerm = "rhic"}),7),((NgramsTerm {unNgramsTerm = "central au"},NgramsTerm {unNgramsTerm = "gev/c"}),6),((NgramsTerm {unNgramsTerm = "data"},NgramsTerm {unNgramsTerm = "pi ^"}),4),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "central collisions"}),3),((NgramsTerm {unNgramsTerm = "centrality dependence"},NgramsTerm {unNgramsTerm = "not found"}),7),((NgramsTerm {unNgramsTerm = "s"},NgramsTerm {unNgramsTerm = "s_nn"}),7),((NgramsTerm {unNgramsTerm = "centrality dependence"},NgramsTerm {unNgramsTerm = "phenix experiment"}),5),((NgramsTerm {unNgramsTerm = "data"},NgramsTerm {unNgramsTerm = "energy"}),3),((NgramsTerm {unNgramsTerm = "ratio"},NgramsTerm {unNgramsTerm = "s"}),4),((NgramsTerm {unNgramsTerm = "function"},NgramsTerm {unNgramsTerm = "nn"}),6),((NgramsTerm {unNgramsTerm = "energy"},NgramsTerm {unNgramsTerm = "p"}),4),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "number"}),11),((NgramsTerm {unNgramsTerm = "p"},NgramsTerm {unNgramsTerm = "spectra"}),5),((NgramsTerm {unNgramsTerm = "central collisions"},NgramsTerm {unNgramsTerm = "s_nn"}),3),((NgramsTerm {unNgramsTerm = "gev/c"},NgramsTerm {unNgramsTerm = "nuclear modification factors"}),4),((NgramsTerm {unNgramsTerm = "energy"},NgramsTerm {unNgramsTerm = "nn"}),6),((NgramsTerm {unNgramsTerm = "measurements"},NgramsTerm {unNgramsTerm = "phenix experiment"}),8),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "not found"}),3),((NgramsTerm {unNgramsTerm = "mid-rapidity"},NgramsTerm {unNgramsTerm = "p collisions"}),3),((NgramsTerm {unNgramsTerm = "measurements"},NgramsTerm {unNgramsTerm = "not found"}),15),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "phenix experiment"}),9),((NgramsTerm {unNgramsTerm = "s_nn"},NgramsTerm {unNgramsTerm = "yields"}),3),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "s"}),14),((NgramsTerm {unNgramsTerm = "measurements"},NgramsTerm {unNgramsTerm = "s"}),18),((NgramsTerm {unNgramsTerm = "not found"},NgramsTerm {unNgramsTerm = "phi"}),4),((NgramsTerm {unNgramsTerm = "d"},NgramsTerm {unNgramsTerm = "yields"}),3),((NgramsTerm {unNgramsTerm = "nuclear modification factors"},NgramsTerm {unNgramsTerm = "rhic"}),5),((NgramsTerm {unNgramsTerm = "function"},NgramsTerm {unNgramsTerm = "gev au"}),3),((NgramsTerm {unNgramsTerm = "phenix experiment"},NgramsTerm {unNgramsTerm = "phi"}),3),((NgramsTerm {unNgramsTerm = "phi"},NgramsTerm {unNgramsTerm = "s"}),9),((NgramsTerm {unNgramsTerm = "gev/c"},NgramsTerm {unNgramsTerm = "midrapidity"}),4),((NgramsTerm {unNgramsTerm = "data"},NgramsTerm {unNgramsTerm = "function"}),6),((NgramsTerm {unNgramsTerm = "relativistic heavy ion collider"},NgramsTerm {unNgramsTerm = "spectra"}),3),((NgramsTerm {unNgramsTerm = "function"},NgramsTerm {unNgramsTerm = "p"}),5),((NgramsTerm {unNgramsTerm = "measurements"},NgramsTerm {unNgramsTerm = "p_t"}),9),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "p_t"}),8),((NgramsTerm {unNgramsTerm = "energy"},NgramsTerm {unNgramsTerm = "eta"}),3),((NgramsTerm {unNgramsTerm = "nn"},NgramsTerm {unNgramsTerm = "spectra"}),6),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "ratio"}),5),((NgramsTerm {unNgramsTerm = "gev/c"},NgramsTerm {unNgramsTerm = "p collisions"}),6),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "measurements"}),23),((NgramsTerm {unNgramsTerm = "p collisions"},NgramsTerm {unNgramsTerm = "relativistic heavy ion collider"}),5),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "phi"}),10),((NgramsTerm {unNgramsTerm = "ratio"},NgramsTerm {unNgramsTerm = "sqrt"}),6),((NgramsTerm {unNgramsTerm = "measurements"},NgramsTerm {unNgramsTerm = "sqrt"}),25),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "sqrt"}),21),((NgramsTerm {unNgramsTerm = "measurements"},NgramsTerm {unNgramsTerm = "particle"}),5),((NgramsTerm {unNgramsTerm = "p collisions"},NgramsTerm {unNgramsTerm = "rhic"}),10),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "particle"}),4),((NgramsTerm {unNgramsTerm = "central collisions"},NgramsTerm {unNgramsTerm = "phenix experiment"}),3),((NgramsTerm {unNgramsTerm = "gev/c"},NgramsTerm {unNgramsTerm = "hadrons"}),8),((NgramsTerm {unNgramsTerm = "gev/c"},NgramsTerm {unNgramsTerm = "transverse momentum"}),3),((NgramsTerm {unNgramsTerm = "s"},NgramsTerm {unNgramsTerm = "yields"}),5),((NgramsTerm {unNgramsTerm = "central au"},NgramsTerm {unNgramsTerm = "function"}),3),((NgramsTerm {unNgramsTerm = "central collisions"},NgramsTerm {unNgramsTerm = "s"}),3),((NgramsTerm {unNgramsTerm = "phi"},NgramsTerm {unNgramsTerm = "sqrt"}),9),((NgramsTerm {unNgramsTerm = "elliptic flow"},NgramsTerm {unNgramsTerm = "hadrons"}),3),((NgramsTerm {unNgramsTerm = "hadrons"},NgramsTerm {unNgramsTerm = "relativistic heavy ion collider"}),3),((NgramsTerm {unNgramsTerm = "mid-rapidity"},NgramsTerm {unNgramsTerm = "spectra"}),3),((NgramsTerm {unNgramsTerm = "function"},NgramsTerm {unNgramsTerm = "pi ^"}),3),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "phi"}),7),((NgramsTerm {unNgramsTerm = "hadrons"},NgramsTerm {unNgramsTerm = "p"}),4),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "measurements"}),14),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "ratio"}),7),((NgramsTerm {unNgramsTerm = "d"},NgramsTerm {unNgramsTerm = "suppression"}),4),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "s_nn"}),17),((NgramsTerm {unNgramsTerm = "phenix experiment"},NgramsTerm {unNgramsTerm = "yields"}),5),((NgramsTerm {unNgramsTerm = "number"},NgramsTerm {unNgramsTerm = "yields"}),3),((NgramsTerm {unNgramsTerm = "rhic"},NgramsTerm {unNgramsTerm = "transverse momentum"}),5),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "d"}),3),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "gev"}),69),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "centralities"}),20),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "centrality dependence"}),8),((NgramsTerm {unNgramsTerm = "hadrons"},NgramsTerm {unNgramsTerm = "rhic"}),6),((NgramsTerm {unNgramsTerm = "nn"},NgramsTerm {unNgramsTerm = "nn"}),99),((NgramsTerm {unNgramsTerm = "pi ^"},NgramsTerm {unNgramsTerm = "pi ^"}),22),((NgramsTerm {unNgramsTerm = "eta"},NgramsTerm {unNgramsTerm = "nn"}),7),((NgramsTerm {unNgramsTerm = "data"},NgramsTerm {unNgramsTerm = "p"}),4),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "phi"}),6),((NgramsTerm {unNgramsTerm = "mid-rapidity"},NgramsTerm {unNgramsTerm = "mid-rapidity"}),18),((NgramsTerm {unNgramsTerm = "midrapidity"},NgramsTerm {unNgramsTerm = "midrapidity"}),13),((NgramsTerm {unNgramsTerm = "eu"},NgramsTerm {unNgramsTerm = "ph"}),5),((NgramsTerm {unNgramsTerm = "measurements"},NgramsTerm {unNgramsTerm = "suppression"}),5),((NgramsTerm {unNgramsTerm = "gev/c"},NgramsTerm {unNgramsTerm = "gev/c"}),30),((NgramsTerm {unNgramsTerm = "central au"},NgramsTerm {unNgramsTerm = "pi ^"}),4),((NgramsTerm {unNgramsTerm = "centrality dependence"},NgramsTerm {unNgramsTerm = "s_nn"}),3),((NgramsTerm {unNgramsTerm = "measurements"},NgramsTerm {unNgramsTerm = "measurements"}),58),((NgramsTerm {unNgramsTerm = "yields"},NgramsTerm {unNgramsTerm = "yields"}),15),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "measurements"}),6),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "suppression"}),3),((NgramsTerm {unNgramsTerm = "hadrons"},NgramsTerm {unNgramsTerm = "p collisions"}),3),((NgramsTerm {unNgramsTerm = "p"},NgramsTerm {unNgramsTerm = "p"}),50),((NgramsTerm {unNgramsTerm = "data"},NgramsTerm {unNgramsTerm = "data"}),44),((NgramsTerm {unNgramsTerm = "sqrt"},NgramsTerm {unNgramsTerm = "sqrt"}),118),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "particle"}),12),((NgramsTerm {unNgramsTerm = "gev au"},NgramsTerm {unNgramsTerm = "p"}),5),((NgramsTerm {unNgramsTerm = "relativistic heavy ion collider"},NgramsTerm {unNgramsTerm = "relativistic heavy ion collider"}),13),((NgramsTerm {unNgramsTerm = "centrality dependence"},NgramsTerm {unNgramsTerm = "centrality dependence"}),18),((NgramsTerm {unNgramsTerm = "gev au"},NgramsTerm {unNgramsTerm = "gev au"}),14),((NgramsTerm {unNgramsTerm = "d"},NgramsTerm {unNgramsTerm = "s_nn"}),5),((NgramsTerm {unNgramsTerm = "function"},NgramsTerm {unNgramsTerm = "function"}),31),((NgramsTerm {unNgramsTerm = "p collisions"},NgramsTerm {unNgramsTerm = "p collisions"}),20),((NgramsTerm {unNgramsTerm = "eu"},NgramsTerm {unNgramsTerm = "eu"}),9),((NgramsTerm {unNgramsTerm = "central au"},NgramsTerm {unNgramsTerm = "central au"}),14),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "sqrt"}),98),((NgramsTerm {unNgramsTerm = "spectra"},NgramsTerm {unNgramsTerm = "spectra"}),16),((NgramsTerm {unNgramsTerm = "gev au"},NgramsTerm {unNgramsTerm = "relativistic heavy ion collider"}),3),((NgramsTerm {unNgramsTerm = "au-au collisions"},NgramsTerm {unNgramsTerm = "nn"}),13),((NgramsTerm {unNgramsTerm = "particle"},NgramsTerm {unNgramsTerm = "sqrt"}),10),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "gev"}),125),((NgramsTerm {unNgramsTerm = "d"},NgramsTerm {unNgramsTerm = "d"}),32),((NgramsTerm {unNgramsTerm = "gev au"},NgramsTerm {unNgramsTerm = "nn"}),10),((NgramsTerm {unNgramsTerm = "s_nn"},NgramsTerm {unNgramsTerm = "s_nn"}),20),((NgramsTerm {unNgramsTerm = "nuclear modification factors"},NgramsTerm {unNgramsTerm = "nuclear modification factors"}),9),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "ratio"}),6),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "centralities"}),28),((NgramsTerm {unNgramsTerm = "gev/c"},NgramsTerm {unNgramsTerm = "rhic"}),9),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "au"}),101),((NgramsTerm {unNgramsTerm = "central collisions"},NgramsTerm {unNgramsTerm = "central collisions"}),9),((NgramsTerm {unNgramsTerm = "thesis"},NgramsTerm {unNgramsTerm = "thesis"}),13),((NgramsTerm {unNgramsTerm = "ph"},NgramsTerm {unNgramsTerm = "ph"}),12),((NgramsTerm {unNgramsTerm = "eta"},NgramsTerm {unNgramsTerm = "eta"}),13),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "particle"}),8),((NgramsTerm {unNgramsTerm = "case study"},NgramsTerm {unNgramsTerm = "case study"}),24),((NgramsTerm {unNgramsTerm = "rhic"},NgramsTerm {unNgramsTerm = "rhic"}),66),((NgramsTerm {unNgramsTerm = "particle"},NgramsTerm {unNgramsTerm = "particle"}),27),((NgramsTerm {unNgramsTerm = "number"},NgramsTerm {unNgramsTerm = "number"}),32),((NgramsTerm {unNgramsTerm = "au-au collisions"},NgramsTerm {unNgramsTerm = "au-au collisions"}),14),((NgramsTerm {unNgramsTerm = "nn"},NgramsTerm {unNgramsTerm = "p"}),18),((NgramsTerm {unNgramsTerm = "p"},NgramsTerm {unNgramsTerm = "relativistic heavy ion collider"}),5),((NgramsTerm {unNgramsTerm = "au-au collisions"},NgramsTerm {unNgramsTerm = "eta"}),3),((NgramsTerm {unNgramsTerm = "nn"},NgramsTerm {unNgramsTerm = "relativistic heavy ion collider"}),4),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "sqrt"}),76),((NgramsTerm {unNgramsTerm = "lambda"},NgramsTerm {unNgramsTerm = "lambda"}),10),((NgramsTerm {unNgramsTerm = "eta"},NgramsTerm {unNgramsTerm = "p"}),3),((NgramsTerm {unNgramsTerm = "energy"},NgramsTerm {unNgramsTerm = "energy"}),25),((NgramsTerm {unNgramsTerm = "central collisions"},NgramsTerm {unNgramsTerm = "yields"}),4),((NgramsTerm {unNgramsTerm = "elliptic flow"},NgramsTerm {unNgramsTerm = "elliptic flow"}),14),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "gev"}),73),((NgramsTerm {unNgramsTerm = "number"},NgramsTerm {unNgramsTerm = "p"}),5),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "spectra"}),9),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "function"}),12),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "pi ^"}),5),((NgramsTerm {unNgramsTerm = "gev/c"},NgramsTerm {unNgramsTerm = "number"}),4),((NgramsTerm {unNgramsTerm = "elliptic flow"},NgramsTerm {unNgramsTerm = "p_t"}),4),((NgramsTerm {unNgramsTerm = "mid-rapidity"},NgramsTerm {unNgramsTerm = "s_nn"}),7),((NgramsTerm {unNgramsTerm = "central au"},NgramsTerm {unNgramsTerm = "sqrt"}),11),((NgramsTerm {unNgramsTerm = "d"},NgramsTerm {unNgramsTerm = "mid-rapidity"}),3),((NgramsTerm {unNgramsTerm = "nuclear modification factors"},NgramsTerm {unNgramsTerm = "suppression"}),3),((NgramsTerm {unNgramsTerm = "energy"},NgramsTerm {unNgramsTerm = "measurements"}),3),((NgramsTerm {unNgramsTerm = "phenix experiment"},NgramsTerm {unNgramsTerm = "rhic"}),15),((NgramsTerm {unNgramsTerm = "number"},NgramsTerm {unNgramsTerm = "rhic"}),6),((NgramsTerm {unNgramsTerm = "p_t"},NgramsTerm {unNgramsTerm = "rhic"}),8),((NgramsTerm {unNgramsTerm = "pi ^"},NgramsTerm {unNgramsTerm = "sqrt"}),11),((NgramsTerm {unNgramsTerm = "not found"},NgramsTerm {unNgramsTerm = "rhic"}),28),((NgramsTerm {unNgramsTerm = "gev/c"},NgramsTerm {unNgramsTerm = "phenix experiment"}),13),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "nuclear modification factors"}),7),((NgramsTerm {unNgramsTerm = "gev/c"},NgramsTerm {unNgramsTerm = "s"}),16),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "pi ^"}),9),((NgramsTerm {unNgramsTerm = "elliptic flow"},NgramsTerm {unNgramsTerm = "not found"}),6),((NgramsTerm {unNgramsTerm = "elliptic flow"},NgramsTerm {unNgramsTerm = "s"}),9),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "central au"}),8),((NgramsTerm {unNgramsTerm = "phenix experiment"},NgramsTerm {unNgramsTerm = "relativistic heavy ion collider"}),6),((NgramsTerm {unNgramsTerm = "not found"},NgramsTerm {unNgramsTerm = "p"}),16),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "midrapidity"}),3),((NgramsTerm {unNgramsTerm = "rhic"},NgramsTerm {unNgramsTerm = "s"}),23),((NgramsTerm {unNgramsTerm = "gev/c"},NgramsTerm {unNgramsTerm = "p_t"}),12),((NgramsTerm {unNgramsTerm = "function"},NgramsTerm {unNgramsTerm = "measurements"}),6),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "energy"}),7),((NgramsTerm {unNgramsTerm = "hadrons"},NgramsTerm {unNgramsTerm = "p_t"}),4),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "pi ^"}),8),((NgramsTerm {unNgramsTerm = "hadrons"},NgramsTerm {unNgramsTerm = "s"}),10),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "midrapidity"}),8),((NgramsTerm {unNgramsTerm = "midrapidity"},NgramsTerm {unNgramsTerm = "sqrt"}),8),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "nuclear modification factors"}),5),((NgramsTerm {unNgramsTerm = "energy"},NgramsTerm {unNgramsTerm = "s_nn"}),3),((NgramsTerm {unNgramsTerm = "d"},NgramsTerm {unNgramsTerm = "energy"}),3),((NgramsTerm {unNgramsTerm = "p collisions"},NgramsTerm {unNgramsTerm = "p_t"}),5),((NgramsTerm {unNgramsTerm = "lambda"},NgramsTerm {unNgramsTerm = "measurements"}),3),((NgramsTerm {unNgramsTerm = "d"},NgramsTerm {unNgramsTerm = "function"}),3),((NgramsTerm {unNgramsTerm = "nn"},NgramsTerm {unNgramsTerm = "yields"}),5),((NgramsTerm {unNgramsTerm = "hadrons"},NgramsTerm {unNgramsTerm = "not found"}),3),((NgramsTerm {unNgramsTerm = "relativistic heavy ion collider"},NgramsTerm {unNgramsTerm = "yields"}),3),((NgramsTerm {unNgramsTerm = "phenix experiment"},NgramsTerm {unNgramsTerm = "transverse momentum"}),5),((NgramsTerm {unNgramsTerm = "pi ^"},NgramsTerm {unNgramsTerm = "ratio"}),3),((NgramsTerm {unNgramsTerm = "measurements"},NgramsTerm {unNgramsTerm = "mid-rapidity"}),5),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "mid-rapidity"}),7),((NgramsTerm {unNgramsTerm = "p collisions"},NgramsTerm {unNgramsTerm = "s"}),13),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "central au"}),14),((NgramsTerm {unNgramsTerm = "central collisions"},NgramsTerm {unNgramsTerm = "nn"}),3),((NgramsTerm {unNgramsTerm = "central au"},NgramsTerm {unNgramsTerm = "ratio"}),4),((NgramsTerm {unNgramsTerm = "p_t"},NgramsTerm {unNgramsTerm = "transverse momentum"}),3),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "midrapidity"}),7),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "nuclear modification factors"}),6),((NgramsTerm {unNgramsTerm = "d"},NgramsTerm {unNgramsTerm = "spectra"}),6),((NgramsTerm {unNgramsTerm = "function"},NgramsTerm {unNgramsTerm = "s_nn"}),8),((NgramsTerm {unNgramsTerm = "centrality dependence"},NgramsTerm {unNgramsTerm = "function"}),6),((NgramsTerm {unNgramsTerm = "nuclear modification factors"},NgramsTerm {unNgramsTerm = "sqrt"}),5),((NgramsTerm {unNgramsTerm = "s"},NgramsTerm {unNgramsTerm = "transverse momentum"}),9),((NgramsTerm {unNgramsTerm = "p"},NgramsTerm {unNgramsTerm = "yields"}),5),((NgramsTerm {unNgramsTerm = "hadrons"},NgramsTerm {unNgramsTerm = "phenix experiment"}),3),((NgramsTerm {unNgramsTerm = "p collisions"},NgramsTerm {unNgramsTerm = "phenix experiment"}),6),((NgramsTerm {unNgramsTerm = "data"},NgramsTerm {unNgramsTerm = "ratio"}),4),((NgramsTerm {unNgramsTerm = "s"},NgramsTerm {unNgramsTerm = "spectra"}),8),((NgramsTerm {unNgramsTerm = "nn"},NgramsTerm {unNgramsTerm = "phi"}),9),((NgramsTerm {unNgramsTerm = "nuclear modification factors"},NgramsTerm {unNgramsTerm = "phenix experiment"}),3),((NgramsTerm {unNgramsTerm = "rhic"},NgramsTerm {unNgramsTerm = "suppression"}),6),((NgramsTerm {unNgramsTerm = "hadrons"},NgramsTerm {unNgramsTerm = "s_nn"}),5),((NgramsTerm {unNgramsTerm = "nuclear modification factors"},NgramsTerm {unNgramsTerm = "s"}),6),((NgramsTerm {unNgramsTerm = "p collisions"},NgramsTerm {unNgramsTerm = "s_nn"}),5),((NgramsTerm {unNgramsTerm = "d"},NgramsTerm {unNgramsTerm = "p collisions"}),4),((NgramsTerm {unNgramsTerm = "midrapidity"},NgramsTerm {unNgramsTerm = "s"}),8),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "relativistic heavy ion collider"}),6),((NgramsTerm {unNgramsTerm = "d"},NgramsTerm {unNgramsTerm = "hadrons"}),3),((NgramsTerm {unNgramsTerm = "data"},NgramsTerm {unNgramsTerm = "phi"}),3),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "eta"}),4),((NgramsTerm {unNgramsTerm = "midrapidity"},NgramsTerm {unNgramsTerm = "not found"}),5),((NgramsTerm {unNgramsTerm = "midrapidity"},NgramsTerm {unNgramsTerm = "phenix experiment"}),5),((NgramsTerm {unNgramsTerm = "d"},NgramsTerm {unNgramsTerm = "transverse momentum"}),5),((NgramsTerm {unNgramsTerm = "gev au"},NgramsTerm {unNgramsTerm = "measurements"}),4),((NgramsTerm {unNgramsTerm = "phenix experiment"},NgramsTerm {unNgramsTerm = "spectra"}),3),((NgramsTerm {unNgramsTerm = "data"},NgramsTerm {unNgramsTerm = "measurements"}),7),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "data"}),5),((NgramsTerm {unNgramsTerm = "nn"},NgramsTerm {unNgramsTerm = "ratio"}),3),((NgramsTerm {unNgramsTerm = "s_nn"},NgramsTerm {unNgramsTerm = "transverse momentum"}),4),((NgramsTerm {unNgramsTerm = "gev/c"},NgramsTerm {unNgramsTerm = "suppression"}),6),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "rhic"}),28),((NgramsTerm {unNgramsTerm = "au-au collisions"},NgramsTerm {unNgramsTerm = "phi"}),3),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "gev/c"}),9),((NgramsTerm {unNgramsTerm = "eta"},NgramsTerm {unNgramsTerm = "measurements"}),3),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "nn"}),15),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "p"}),20),((NgramsTerm {unNgramsTerm = "measurements"},NgramsTerm {unNgramsTerm = "nn"}),13),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "elliptic flow"}),3),((NgramsTerm {unNgramsTerm = "mid-rapidity"},NgramsTerm {unNgramsTerm = "yields"}),4),((NgramsTerm {unNgramsTerm = "p"},NgramsTerm {unNgramsTerm = "ratio"}),6),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "gev au"}),4),((NgramsTerm {unNgramsTerm = "rhic"},NgramsTerm {unNgramsTerm = "sqrt"}),31),((NgramsTerm {unNgramsTerm = "hadrons"},NgramsTerm {unNgramsTerm = "suppression"}),3),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "gev/c"}),15),((NgramsTerm {unNgramsTerm = "d"},NgramsTerm {unNgramsTerm = "nn"}),8),((NgramsTerm {unNgramsTerm = "relativistic heavy ion collider"},NgramsTerm {unNgramsTerm = "s_nn"}),4),((NgramsTerm {unNgramsTerm = "mid-rapidity"},NgramsTerm {unNgramsTerm = "phenix experiment"}),7),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "transverse momentum"}),10),((NgramsTerm {unNgramsTerm = "particle"},NgramsTerm {unNgramsTerm = "rhic"}),5),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "rhic"}),23),((NgramsTerm {unNgramsTerm = "nn"},NgramsTerm {unNgramsTerm = "s_nn"}),6),((NgramsTerm {unNgramsTerm = "d"},NgramsTerm {unNgramsTerm = "p"}),16),((NgramsTerm {unNgramsTerm = "p_t"},NgramsTerm {unNgramsTerm = "pi ^"}),5),((NgramsTerm {unNgramsTerm = "spectra"},NgramsTerm {unNgramsTerm = "yields"}),3),((NgramsTerm {unNgramsTerm = "phenix experiment"},NgramsTerm {unNgramsTerm = "pi ^"}),5),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "p collisions"}),7),((NgramsTerm {unNgramsTerm = "gev/c"},NgramsTerm {unNgramsTerm = "particle"}),3),((NgramsTerm {unNgramsTerm = "measurements"},NgramsTerm {unNgramsTerm = "p collisions"}),7),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "hadrons"}),10),((NgramsTerm {unNgramsTerm = "centrality dependence"},NgramsTerm {unNgramsTerm = "p"}),4),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "gev/c"}),24),((NgramsTerm {unNgramsTerm = "hadrons"},NgramsTerm {unNgramsTerm = "measurements"}),4),((NgramsTerm {unNgramsTerm = "mid-rapidity"},NgramsTerm {unNgramsTerm = "p_t"}),6),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "elliptic flow"}),10),((NgramsTerm {unNgramsTerm = "lambda"},NgramsTerm {unNgramsTerm = "not found"}),3),((NgramsTerm {unNgramsTerm = "mid-rapidity"},NgramsTerm {unNgramsTerm = "s"}),8),((NgramsTerm {unNgramsTerm = "elliptic flow"},NgramsTerm {unNgramsTerm = "sqrt"}),10),((NgramsTerm {unNgramsTerm = "lambda"},NgramsTerm {unNgramsTerm = "s"}),7),((NgramsTerm {unNgramsTerm = "centrality dependence"},NgramsTerm {unNgramsTerm = "nn"}),11),((NgramsTerm {unNgramsTerm = "p"},NgramsTerm {unNgramsTerm = "s_nn"}),9),((NgramsTerm {unNgramsTerm = "centrality dependence"},NgramsTerm {unNgramsTerm = "data"}),4),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "rhic"}),27),((NgramsTerm {unNgramsTerm = "gev au"},NgramsTerm {unNgramsTerm = "s_nn"}),4),((NgramsTerm {unNgramsTerm = "not found"},NgramsTerm {unNgramsTerm = "pi ^"}),8),((NgramsTerm {unNgramsTerm = "elliptic flow"},NgramsTerm {unNgramsTerm = "gev"}),11),((NgramsTerm {unNgramsTerm = "gev/c"},NgramsTerm {unNgramsTerm = "sqrt"}),22),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "not found"}),61),((NgramsTerm {unNgramsTerm = "energy"},NgramsTerm {unNgramsTerm = "hadrons"}),3),((NgramsTerm {unNgramsTerm = "data"},NgramsTerm {unNgramsTerm = "mid-rapidity"}),6),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "number"}),12),((NgramsTerm {unNgramsTerm = "phenix experiment"},NgramsTerm {unNgramsTerm = "sqrt"}),19),((NgramsTerm {unNgramsTerm = "number"},NgramsTerm {unNgramsTerm = "sqrt"}),10),((NgramsTerm {unNgramsTerm = "energy"},NgramsTerm {unNgramsTerm = "transverse momentum"}),3),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "phenix experiment"}),20),((NgramsTerm {unNgramsTerm = "function"},NgramsTerm {unNgramsTerm = "transverse momentum"}),4),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "p_t"}),16),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "s"}),64),((NgramsTerm {unNgramsTerm = "lambda"},NgramsTerm {unNgramsTerm = "nn"}),6),((NgramsTerm {unNgramsTerm = "not found"},NgramsTerm {unNgramsTerm = "sqrt"}),62),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "not found"}),56),((NgramsTerm {unNgramsTerm = "measurements"},NgramsTerm {unNgramsTerm = "yields"}),3),((NgramsTerm {unNgramsTerm = "central au"},NgramsTerm {unNgramsTerm = "rhic"}),5),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "number"}),10),((NgramsTerm {unNgramsTerm = "pi ^"},NgramsTerm {unNgramsTerm = "rhic"}),8),((NgramsTerm {unNgramsTerm = "s"},NgramsTerm {unNgramsTerm = "sqrt"}),100),((NgramsTerm {unNgramsTerm = "phi"},NgramsTerm {unNgramsTerm = "yields"}),3),((NgramsTerm {unNgramsTerm = "central collisions"},NgramsTerm {unNgramsTerm = "centralities"}),3),((NgramsTerm {unNgramsTerm = "number"},NgramsTerm {unNgramsTerm = "particle"}),4),((NgramsTerm {unNgramsTerm = "central collisions"},NgramsTerm {unNgramsTerm = "measurements"}),3),((NgramsTerm {unNgramsTerm = "gev/c"},NgramsTerm {unNgramsTerm = "pi ^"}),6),((NgramsTerm {unNgramsTerm = "pi ^"},NgramsTerm {unNgramsTerm = "relativistic heavy ion collider"}),3),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "p_t"}),10),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "s"}),85),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "phenix experiment"}),16),((NgramsTerm {unNgramsTerm = "particle"},NgramsTerm {unNgramsTerm = "s"}),10),((NgramsTerm {unNgramsTerm = "not found"},NgramsTerm {unNgramsTerm = "particle"}),3),((NgramsTerm {unNgramsTerm = "central au"},NgramsTerm {unNgramsTerm = "p"}),6),((NgramsTerm {unNgramsTerm = "p_t"},NgramsTerm {unNgramsTerm = "sqrt"}),15),((NgramsTerm {unNgramsTerm = "mid-rapidity"},NgramsTerm {unNgramsTerm = "nn"}),6),((NgramsTerm {unNgramsTerm = "gev/c"},NgramsTerm {unNgramsTerm = "spectra"}),4),((NgramsTerm {unNgramsTerm = "central collisions"},NgramsTerm {unNgramsTerm = "gev"}),6),((NgramsTerm {unNgramsTerm = "rhic"},NgramsTerm {unNgramsTerm = "spectra"}),6),((NgramsTerm {unNgramsTerm = "energy"},NgramsTerm {unNgramsTerm = "rhic"}),4),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "central collisions"}),5),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "phenix experiment"}),18),((NgramsTerm {unNgramsTerm = "s"},NgramsTerm {unNgramsTerm = "suppression"}),6),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "not found"}),55),((NgramsTerm {unNgramsTerm = "account"},NgramsTerm {unNgramsTerm = "number"}),3),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "yields"}),12),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "s"}),66),((NgramsTerm {unNgramsTerm = "function"},NgramsTerm {unNgramsTerm = "gev/c"}),5),((NgramsTerm {unNgramsTerm = "sqrt"},NgramsTerm {unNgramsTerm = "yields"}),9),((NgramsTerm {unNgramsTerm = "midrapidity"},NgramsTerm {unNgramsTerm = "nn"}),7),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "p_t"}),11),((NgramsTerm {unNgramsTerm = "midrapidity"},NgramsTerm {unNgramsTerm = "relativistic heavy ion collider"}),4),((NgramsTerm {unNgramsTerm = "function"},NgramsTerm {unNgramsTerm = "rhic"}),8),((NgramsTerm {unNgramsTerm = "central collisions"},NgramsTerm {unNgramsTerm = "sqrt"}),5),((NgramsTerm {unNgramsTerm = "p_t"},NgramsTerm {unNgramsTerm = "suppression"}),3),((NgramsTerm {unNgramsTerm = "nn"},NgramsTerm {unNgramsTerm = "nuclear modification factors"}),6),((NgramsTerm {unNgramsTerm = "central au"},NgramsTerm {unNgramsTerm = "p collisions"}),3),((NgramsTerm {unNgramsTerm = "p collisions"},NgramsTerm {unNgramsTerm = "pi ^"}),4),((NgramsTerm {unNgramsTerm = "phenix experiment"},NgramsTerm {unNgramsTerm = "suppression"}),5),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "number"}),7),((NgramsTerm {unNgramsTerm = "nuclear modification factors"},NgramsTerm {unNgramsTerm = "p"}),5),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "yields"}),8),((NgramsTerm {unNgramsTerm = "midrapidity"},NgramsTerm {unNgramsTerm = "p"}),6),((NgramsTerm {unNgramsTerm = "mid-rapidity"},NgramsTerm {unNgramsTerm = "transverse momentum"}),4),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "gev"}),22),((NgramsTerm {unNgramsTerm = "sqrt"},NgramsTerm {unNgramsTerm = "suppression"}),6),((NgramsTerm {unNgramsTerm = "nn"},NgramsTerm {unNgramsTerm = "transverse momentum"}),9),((NgramsTerm {unNgramsTerm = "eta"},NgramsTerm {unNgramsTerm = "transverse momentum"}),3),((NgramsTerm {unNgramsTerm = "hadrons"},NgramsTerm {unNgramsTerm = "nn"}),10),((NgramsTerm {unNgramsTerm = "centrality dependence"},NgramsTerm {unNgramsTerm = "measurements"}),3),((NgramsTerm {unNgramsTerm = "nuclear modification factors"},NgramsTerm {unNgramsTerm = "pi ^"}),4),((NgramsTerm {unNgramsTerm = "au-au collisions"},NgramsTerm {unNgramsTerm = "transverse momentum"}),3),((NgramsTerm {unNgramsTerm = "central au"},NgramsTerm {unNgramsTerm = "nuclear modification factors"}),3),((NgramsTerm {unNgramsTerm = "function"},NgramsTerm {unNgramsTerm = "mid-rapidity"}),5),((NgramsTerm {unNgramsTerm = "data"},NgramsTerm {unNgramsTerm = "transverse momentum"}),3),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "d"}),17),((NgramsTerm {unNgramsTerm = "d"},NgramsTerm {unNgramsTerm = "measurements"}),5),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "suppression"}),5),((NgramsTerm {unNgramsTerm = "particle"},NgramsTerm {unNgramsTerm = "suppression"}),3),((NgramsTerm {unNgramsTerm = "d"},NgramsTerm {unNgramsTerm = "ratio"}),3),((NgramsTerm {unNgramsTerm = "pi ^"},NgramsTerm {unNgramsTerm = "spectra"}),4),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "centrality dependence"}),12),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "particle"}),11),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "sqrt"}),77),((NgramsTerm {unNgramsTerm = "p"},NgramsTerm {unNgramsTerm = "transverse momentum"}),4),((NgramsTerm {unNgramsTerm = "p"},NgramsTerm {unNgramsTerm = "p collisions"}),18),((NgramsTerm {unNgramsTerm = "measurements"},NgramsTerm {unNgramsTerm = "s_nn"}),8),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "s_nn"}),11),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "au collisions"}),76),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "suppression"}),7),((NgramsTerm {unNgramsTerm = "nn"},NgramsTerm {unNgramsTerm = "p collisions"}),8),((NgramsTerm {unNgramsTerm = "d"},NgramsTerm {unNgramsTerm = "gev"}),12),((NgramsTerm {unNgramsTerm = "data"},NgramsTerm {unNgramsTerm = "gev/c"}),4),((NgramsTerm {unNgramsTerm = "stability"},NgramsTerm {unNgramsTerm = "stability"}),8),((NgramsTerm {unNgramsTerm = "second part"},NgramsTerm {unNgramsTerm = "second part"}),8),((NgramsTerm {unNgramsTerm = "data"},NgramsTerm {unNgramsTerm = "rhic"}),8),((NgramsTerm {unNgramsTerm = "elliptic flow"},NgramsTerm {unNgramsTerm = "nn"}),9),((NgramsTerm {unNgramsTerm = "aspects"},NgramsTerm {unNgramsTerm = "aspects"}),9),((NgramsTerm {unNgramsTerm = "p_t"},NgramsTerm {unNgramsTerm = "s"}),9),((NgramsTerm {unNgramsTerm = "s_nn"},NgramsTerm {unNgramsTerm = "sqrt"}),20),((NgramsTerm {unNgramsTerm = "suppression"},NgramsTerm {unNgramsTerm = "suppression"}),16),((NgramsTerm {unNgramsTerm = "not found"},NgramsTerm {unNgramsTerm = "s"}),64),((NgramsTerm {unNgramsTerm = "not found"},NgramsTerm {unNgramsTerm = "not found"}),543),((NgramsTerm {unNgramsTerm = "centrality dependence"},NgramsTerm {unNgramsTerm = "gev"}),14),((NgramsTerm {unNgramsTerm = "hadrons"},NgramsTerm {unNgramsTerm = "hadrons"}),19),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "centrality dependence"}),12),((NgramsTerm {unNgramsTerm = "d"},NgramsTerm {unNgramsTerm = "sqrt"}),13),((NgramsTerm {unNgramsTerm = "central au"},NgramsTerm {unNgramsTerm = "mid-rapidity"}),3),((NgramsTerm {unNgramsTerm = "phenix experiment"},NgramsTerm {unNgramsTerm = "s"}),10),((NgramsTerm {unNgramsTerm = "mid-rapidity"},NgramsTerm {unNgramsTerm = "pi ^"}),4),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "phi"}),4),((NgramsTerm {unNgramsTerm = "particle"},NgramsTerm {unNgramsTerm = "s_nn"}),3),((NgramsTerm {unNgramsTerm = "nn"},NgramsTerm {unNgramsTerm = "rhic"}),18),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "centralities"}),19),((NgramsTerm {unNgramsTerm = "number"},NgramsTerm {unNgramsTerm = "s"}),11),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "s_nn"}),19),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "suppression"}),9),((NgramsTerm {unNgramsTerm = "gev/c"},NgramsTerm {unNgramsTerm = "nn"}),13),((NgramsTerm {unNgramsTerm = "p_t"},NgramsTerm {unNgramsTerm = "phenix experiment"}),8),((NgramsTerm {unNgramsTerm = "relativistic heavy ion collider"},NgramsTerm {unNgramsTerm = "rhic"}),7),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "au collisions"}),102),((NgramsTerm {unNgramsTerm = "transverse momentum"},NgramsTerm {unNgramsTerm = "transverse momentum"}),15),((NgramsTerm {unNgramsTerm = "function"},NgramsTerm {unNgramsTerm = "nuclear modification factors"}),3),((NgramsTerm {unNgramsTerm = "eta"},NgramsTerm {unNgramsTerm = "gev/c"}),3),((NgramsTerm {unNgramsTerm = "data"},NgramsTerm {unNgramsTerm = "ph"}),3),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "ratio"}),4),((NgramsTerm {unNgramsTerm = "number"},NgramsTerm {unNgramsTerm = "phenix experiment"}),4),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "measurements"}),15),((NgramsTerm {unNgramsTerm = "measurements"},NgramsTerm {unNgramsTerm = "ratio"}),5),((NgramsTerm {unNgramsTerm = "phenix experiment"},NgramsTerm {unNgramsTerm = "phenix experiment"}),25),((NgramsTerm {unNgramsTerm = "phi"},NgramsTerm {unNgramsTerm = "phi"}),12),((NgramsTerm {unNgramsTerm = "data"},NgramsTerm {unNgramsTerm = "eu"}),4),((NgramsTerm {unNgramsTerm = "gev/c"},NgramsTerm {unNgramsTerm = "relativistic heavy ion collider"}),5),((NgramsTerm {unNgramsTerm = "centrality dependence"},NgramsTerm {unNgramsTerm = "sqrt"}),10),((NgramsTerm {unNgramsTerm = "ratio"},NgramsTerm {unNgramsTerm = "ratio"}),11),((NgramsTerm {unNgramsTerm = "account"},NgramsTerm {unNgramsTerm = "account"}),17),((NgramsTerm {unNgramsTerm = "au-au collisions"},NgramsTerm {unNgramsTerm = "rhic"}),3),((NgramsTerm {unNgramsTerm = "gev/c"},NgramsTerm {unNgramsTerm = "p"}),12),((NgramsTerm {unNgramsTerm = "gev au"},NgramsTerm {unNgramsTerm = "rhic"}),7),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "d"}),15),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "s_nn"}),15),((NgramsTerm {unNgramsTerm = "s"},NgramsTerm {unNgramsTerm = "s"}),118),((NgramsTerm {unNgramsTerm = "p_t"},NgramsTerm {unNgramsTerm = "p_t"}),17),((NgramsTerm {unNgramsTerm = "p collisions"},NgramsTerm {unNgramsTerm = "transverse momentum"}),3),((NgramsTerm {unNgramsTerm = "p"},NgramsTerm {unNgramsTerm = "rhic"}),18),((NgramsTerm {unNgramsTerm = "p"},NgramsTerm {unNgramsTerm = "p_t"}),9),((NgramsTerm {unNgramsTerm = "mid-rapidity"},NgramsTerm {unNgramsTerm = "sqrt"}),14),((NgramsTerm {unNgramsTerm = "au-au collisions"},NgramsTerm {unNgramsTerm = "s"}),10),((NgramsTerm {unNgramsTerm = "pi ^"},NgramsTerm {unNgramsTerm = "s_nn"}),4),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "function"}),13),((NgramsTerm {unNgramsTerm = "nn"},NgramsTerm {unNgramsTerm = "not found"}),63),((NgramsTerm {unNgramsTerm = "central au"},NgramsTerm {unNgramsTerm = "s_nn"}),4),((NgramsTerm {unNgramsTerm = "nuclear modification factors"},NgramsTerm {unNgramsTerm = "phi"}),3),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "lambda"}),7),((NgramsTerm {unNgramsTerm = "d"},NgramsTerm {unNgramsTerm = "pi ^"}),3),((NgramsTerm {unNgramsTerm = "relativistic heavy ion collider"},NgramsTerm {unNgramsTerm = "s"}),6),((NgramsTerm {unNgramsTerm = "nuclear modification factors"},NgramsTerm {unNgramsTerm = "ratio"}),3),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "energy"}),7),((NgramsTerm {unNgramsTerm = "nn"},NgramsTerm {unNgramsTerm = "p_t"}),6),((NgramsTerm {unNgramsTerm = "measurements"},NgramsTerm {unNgramsTerm = "nuclear modification factors"}),4),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "nuclear modification factors"}),4),((NgramsTerm {unNgramsTerm = "spectra"},NgramsTerm {unNgramsTerm = "suppression"}),3),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "mid-rapidity"}),12),((NgramsTerm {unNgramsTerm = "nn"},NgramsTerm {unNgramsTerm = "s"}),89),((NgramsTerm {unNgramsTerm = "measurements"},NgramsTerm {unNgramsTerm = "spectra"}),5),((NgramsTerm {unNgramsTerm = "lambda"},NgramsTerm {unNgramsTerm = "sqrt"}),7),((NgramsTerm {unNgramsTerm = "nn"},NgramsTerm {unNgramsTerm = "phenix experiment"}),9),((NgramsTerm {unNgramsTerm = "nn"},NgramsTerm {unNgramsTerm = "number"}),9),((NgramsTerm {unNgramsTerm = "central au"},NgramsTerm {unNgramsTerm = "gev"}),10),((NgramsTerm {unNgramsTerm = "eta"},NgramsTerm {unNgramsTerm = "s"}),7),((NgramsTerm {unNgramsTerm = "gev au"},NgramsTerm {unNgramsTerm = "not found"}),7),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "midrapidity"}),7),((NgramsTerm {unNgramsTerm = "data"},NgramsTerm {unNgramsTerm = "phenix experiment"}),3),((NgramsTerm {unNgramsTerm = "data"},NgramsTerm {unNgramsTerm = "s"}),5),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "lambda"}),5),((NgramsTerm {unNgramsTerm = "p"},NgramsTerm {unNgramsTerm = "s"}),22),((NgramsTerm {unNgramsTerm = "au-au collisions"},NgramsTerm {unNgramsTerm = "not found"}),8),((NgramsTerm {unNgramsTerm = "p"},NgramsTerm {unNgramsTerm = "phenix experiment"}),13),((NgramsTerm {unNgramsTerm = "gev au"},NgramsTerm {unNgramsTerm = "s"}),8),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "mid-rapidity"}),15),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "energy"}),8),((NgramsTerm {unNgramsTerm = "mid-rapidity"},NgramsTerm {unNgramsTerm = "ratio"}),3),((NgramsTerm {unNgramsTerm = "function"},NgramsTerm {unNgramsTerm = "particle"}),6),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "function"}),13),((NgramsTerm {unNgramsTerm = "energy"},NgramsTerm {unNgramsTerm = "particle"}),4),((NgramsTerm {unNgramsTerm = "measurements"},NgramsTerm {unNgramsTerm = "pi ^"}),8),((NgramsTerm {unNgramsTerm = "gev/c"},NgramsTerm {unNgramsTerm = "yields"}),5),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "pi ^"}),5),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "spectra"}),7),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "mid-rapidity"}),13),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "lambda"}),5),((NgramsTerm {unNgramsTerm = "function"},NgramsTerm {unNgramsTerm = "gev"}),14),((NgramsTerm {unNgramsTerm = "central au"},NgramsTerm {unNgramsTerm = "centralities"}),5),((NgramsTerm {unNgramsTerm = "rhic"},NgramsTerm {unNgramsTerm = "yields"}),4),((NgramsTerm {unNgramsTerm = "number"},NgramsTerm {unNgramsTerm = "p collisions"}),3),((NgramsTerm {unNgramsTerm = "function"},NgramsTerm {unNgramsTerm = "sqrt"}),12),((NgramsTerm {unNgramsTerm = "mid-rapidity"},NgramsTerm {unNgramsTerm = "phi"}),3),((NgramsTerm {unNgramsTerm = "spectra"},NgramsTerm {unNgramsTerm = "sqrt"}),10),((NgramsTerm {unNgramsTerm = "pi ^"},NgramsTerm {unNgramsTerm = "suppression"}),3),((NgramsTerm {unNgramsTerm = "not found"},NgramsTerm {unNgramsTerm = "p collisions"}),6),((NgramsTerm {unNgramsTerm = "energy"},NgramsTerm {unNgramsTerm = "sqrt"}),10),((NgramsTerm {unNgramsTerm = "energy"},NgramsTerm {unNgramsTerm = "gev"}),9),((NgramsTerm {unNgramsTerm = "central collisions"},NgramsTerm {unNgramsTerm = "gev/c"}),4),((NgramsTerm {unNgramsTerm = "hadrons"},NgramsTerm {unNgramsTerm = "number"}),3),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "spectra"}),9),((NgramsTerm {unNgramsTerm = "central au"},NgramsTerm {unNgramsTerm = "suppression"}),4),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "gev/c"}),18),((NgramsTerm {unNgramsTerm = "phi"},NgramsTerm {unNgramsTerm = "rhic"}),3),((NgramsTerm {unNgramsTerm = "function"},NgramsTerm {unNgramsTerm = "phenix experiment"}),9),((NgramsTerm {unNgramsTerm = "elliptic flow"},NgramsTerm {unNgramsTerm = "measurements"}),3),((NgramsTerm {unNgramsTerm = "function"},NgramsTerm {unNgramsTerm = "s"}),5),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "gev au"}),12),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "elliptic flow"}),10),((NgramsTerm {unNgramsTerm = "p"},NgramsTerm {unNgramsTerm = "suppression"}),5),((NgramsTerm {unNgramsTerm = "gev/c"},NgramsTerm {unNgramsTerm = "measurements"}),11),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "p collisions"}),11),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "eta"}),4),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "transverse momentum"}),14),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "hadrons"}),11),((NgramsTerm {unNgramsTerm = "function"},NgramsTerm {unNgramsTerm = "number"}),3),((NgramsTerm {unNgramsTerm = "energy"},NgramsTerm {unNgramsTerm = "s"}),7),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "data"}),6),((NgramsTerm {unNgramsTerm = "measurements"},NgramsTerm {unNgramsTerm = "relativistic heavy ion collider"}),7),((NgramsTerm {unNgramsTerm = "au collisions"},NgramsTerm {unNgramsTerm = "nn"}),67),((NgramsTerm {unNgramsTerm = "ratio"},NgramsTerm {unNgramsTerm = "rhic"}),4),((NgramsTerm {unNgramsTerm = "sqrt"},NgramsTerm {unNgramsTerm = "transverse momentum"}),13),((NgramsTerm {unNgramsTerm = "hadrons"},NgramsTerm {unNgramsTerm = "sqrt"}),11),((NgramsTerm {unNgramsTerm = "p collisions"},NgramsTerm {unNgramsTerm = "sqrt"}),16),((NgramsTerm {unNgramsTerm = "function"},NgramsTerm {unNgramsTerm = "p_t"}),6),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "p"}),10),((NgramsTerm {unNgramsTerm = "measurements"},NgramsTerm {unNgramsTerm = "p"}),14),((NgramsTerm {unNgramsTerm = "centralities"},NgramsTerm {unNgramsTerm = "rhic"}),6),((NgramsTerm {unNgramsTerm = "gev"},NgramsTerm {unNgramsTerm = "p collisions"}),15),((NgramsTerm {unNgramsTerm = "measurements"},NgramsTerm {unNgramsTerm = "rhic"}),15),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "transverse momentum"}),7),((NgramsTerm {unNgramsTerm = "au"},NgramsTerm {unNgramsTerm = "hadrons"}),8),((NgramsTerm {unNgramsTerm = "nn"},NgramsTerm {unNgramsTerm = "suppression"}),6)]



test :: Spec
test = do
  describe "Cross" $ do
    let
      (distanceMap,_,_) = doSimilarityMap Conditional 0 Weak myCooc
    it "Partition test" $ do
      partitions <- spinglass 1 distanceMap
      let
        result = List.length partitions > 1
      shouldBe True result
