
module Main where

import Prelude
import Data.TreeDiff.Class
import Data.TreeDiff.Pretty
import qualified Data.Text as T
import qualified Data.Text.IO as TIO
import System.Environment (getArgs)
import System.Exit (exitFailure)
import Control.Monad (unless)
import qualified Data.List as L

-- | Renders in a pretty way the content of two golden files. The
-- first file should contain the expected output, the second the
-- actual data generated by the test suite.
main :: IO ()
main = do
  (refPath:newPath:_) <- getArgs
  ref <- T.lines <$> TIO.readFile refPath
  new <- T.lines <$> TIO.readFile newPath

  let differences = filter (\(r,n) -> r /= n) $ zip ref new

  unless (L.null differences) $ do
    putStrLn $ show $ ansiWlEditExpr $ ediff' (map fst differences) (map snd differences)
    exitFailure
