{-|
Module      : Test.Database.Operations.PublishNode
Description : GarganText database tests
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX
-}

{-# LANGUAGE QuasiQuotes       #-}

module Test.Database.Operations.PublishNode where

import Prelude

import Control.Monad.Reader
import Gargantext.Core
import Gargantext.Database.Admin.Types.Node
import Gargantext.Database.Query.Table.Node
import Gargantext.Database.Schema.Node (NodePoly(..))

import Test.API.Setup (createAliceAndBob)
import Test.Database.Types
import Test.Tasty.HUnit

testGetUserRootPublicNode :: TestEnv -> Assertion
testGetUserRootPublicNode testEnv = do
  [aliceId, _bobId] <- createAliceAndBob testEnv
  alicePublicFolder <- flip runReaderT testEnv $ runTestMonad $ do
    getUserRootPublicNode aliceId
  _node_typename alicePublicFolder @?= (toDBid NodeFolderPublic)
