{-|
Module      : Gargantext.API..Types
Description : Ngrams List Types
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

{-# OPTIONS_GHC -fprint-potential-instances #-}

module Gargantext.API.Types where

import Data.Aeson
import Data.ByteString.Lazy.Char8 qualified as BS8
import Data.Typeable
import Gargantext.Prelude
import Network.HTTP.Media ((//), (/:))
import Servant
  ( Accept(..)
  , MimeRender(..)
  , MimeUnrender(..) )

data HTML deriving (Typeable)
instance Accept HTML where
  contentTypes _ = "text" // "html" /: ("charset", "utf-8") :| ["text" // "html"]
instance MimeRender HTML BS8.ByteString where
  mimeRender _ = identity
instance MimeUnrender HTML BS8.ByteString where
    mimeUnrender _ bs = Right bs
instance MimeRender HTML Text where
    mimeRender _ = toUtf8Lazy
instance MimeUnrender HTML Text where
    mimeUnrender _ bs = Right $ decodeUtf8 $ BS8.toStrict bs
instance {-# OVERLAPPABLE #-} ToJSON a => MimeRender HTML a where
  mimeRender _ = encode
