{-# LANGUAGE TypeOperators #-}
{-# LANGUAGE DeriveGeneric #-}
module Gargantext.API.Routes.Named.Metrics (
  -- * Routes types

    TreeAPI(..)
  , ScatterAPI(..)
  , ChartAPI(..)
  , PieAPI(..)
  ) where

import Data.Text (Text)
import Data.Time
import Data.Vector
import GHC.Generics
import Gargantext.API.HashedResponse
import Gargantext.API.Ngrams.NgramsTree
import Gargantext.API.Ngrams.Types
import Gargantext.Core.Types.Main
import Gargantext.Core.Types.Query (Limit)
import Gargantext.Core.Viz.Types
import Gargantext.Database.Admin.Types.Metrics
import Gargantext.Database.Admin.Types.Node
import Servant


data TreeAPI mode = TreeAPI
  { treeChartEp       :: mode :- Summary " Tree API"
                              :> QueryParam "from" UTCTime
                              :> QueryParam "to"   UTCTime
                              :> QueryParam  "list"       ListId
                              :> QueryParamR "ngramsType" TabType
                              :> QueryParamR "listType"   ListType
                              :> Get '[JSON] (HashedResponse (ChartMetrics (Vector NgramsTree)))
  , treeChartUpdateEp :: mode :- Summary "Tree Chart update"
                              :> QueryParam  "list"       ListId
                              :> QueryParamR "ngramsType" TabType
                              :> QueryParamR "listType"   ListType
                              :> Post '[JSON] ()
  , treeHashEp        :: mode :- "hash"
                              :> Summary "Tree Hash"
                              :> QueryParam  "list"       ListId
                              :> QueryParamR "ngramsType" TabType
                              :> QueryParamR "listType"   ListType
                              :> Get '[JSON] Text
  } deriving Generic


data ScatterAPI mode = ScatterAPI
  { sepGenEp :: mode :- Summary "SepGen IncExc metrics"
                     :> QueryParam  "list"       ListId
                     :> QueryParamR "ngramsType" TabType
                     :> QueryParam  "limit"      Limit
                     :> Get '[JSON] (HashedResponse Metrics)
  , scatterUpdateEp :: mode :- Summary "Scatter update"
                            :> QueryParam  "list"       ListId
                            :> QueryParamR "ngramsType" TabType
                            :> QueryParam  "limit"      Limit
                            :> Post '[JSON] ()
  , scatterHashEp :: mode :- "hash"
                          :> Summary "Scatter Hash"
                          :> QueryParam  "list"       ListId
                          :> QueryParamR "ngramsType" TabType
                          :> Get '[JSON] Text
  } deriving Generic


data PieAPI mode = PieAPI
  { getPieChartEp :: mode :- Summary "Pie Chart"
                          :> QueryParam "from" UTCTime
                          :> QueryParam "to"   UTCTime
                          :> QueryParam  "list"       ListId
                          :> QueryParamR "ngramsType" TabType
                          :> Get '[JSON] (HashedResponse (ChartMetrics Histo))
  , pieChartUpdateEp :: mode :- Summary "Pie Chart update"
                             :> QueryParam  "list"       ListId
                             :> QueryParamR "ngramsType" TabType
                             :> QueryParam  "limit"      Limit
                             :> Post '[JSON] ()
  , pieHashEp :: mode :- "hash"
                      :> Summary "Pie Hash"
                      :> QueryParam  "list"       ListId
                      :> QueryParamR "ngramsType" TabType
                      :> Get '[JSON] Text
  } deriving Generic


data ChartAPI mode = ChartAPI
  { getChartEp :: mode :- Summary " Chart API"
                       :> QueryParam "from" UTCTime
                       :> QueryParam "to"   UTCTime
                       :> QueryParam  "list"       ListId
                       :> QueryParamR "ngramsType" TabType
                       :> Get '[JSON] (HashedResponse (ChartMetrics Histo))
  , updateChartEp :: mode :- Summary "Chart update"
                          :> QueryParam  "list"       ListId
                          :> QueryParamR "ngramsType" TabType
                          :> QueryParam  "limit"      Limit
                          :> Post '[JSON] ()
  , chartHashEp :: mode :- "hash"
                        :> Summary "Chart Hash"
                        :> QueryParam  "list"       ListId
                        :> QueryParamR "ngramsType" TabType
                        :> Get '[JSON] Text
  } deriving Generic

