
{-# LANGUAGE TypeOperators #-}
{-# LANGUAGE DeriveGeneric #-}

module Gargantext.API.Routes.Named.Private (
  -- * Routes types
    GargPrivateAPI
  , GargPrivateAPI'(..)
  , GargAdminAPI(..)
  , NodeEndpoint(..)
  , MembersAPI(..)
  ) where

import Data.Text (Text)
import GHC.Generics
import Gargantext.API.Admin.Auth.Types
import Gargantext.API.Auth.PolicyCheck
import Gargantext.API.Routes.Named.Contact
import Gargantext.API.Routes.Named.Context
import Gargantext.API.Routes.Named.Corpus
import Gargantext.API.Routes.Named.Count
import Gargantext.API.Routes.Named.Document
import Gargantext.API.Routes.Named.Metrics
import Gargantext.API.Routes.Named.Node
import Gargantext.API.Routes.Named.List qualified as List
import Gargantext.API.Routes.Named.Share
import Gargantext.API.Routes.Named.Tree
import Gargantext.API.Routes.Named.Table
import Gargantext.API.Routes.Named.Viz
import Gargantext.Database.Admin.Types.Hyperdata.Any
import Gargantext.Database.Admin.Types.Hyperdata.Corpus
import Gargantext.Database.Admin.Types.Node
import Servant.API
import Servant.Auth qualified as SA


type MkProtectedAPI private = SA.Auth '[SA.JWT, SA.Cookie] AuthenticatedUser :> private


newtype GargPrivateAPI mode = GargPrivateAPI
  { mkPrivateAPI :: mode :- MkProtectedAPI (NamedRoutes GargPrivateAPI')
  } deriving Generic


data GargPrivateAPI' mode = GargPrivateAPI'
  { gargAdminAPI :: mode :- NamedRoutes GargAdminAPI
  , nodeEp       :: mode :- NamedRoutes NodeEndpoint
  , contextEp    :: mode :- "context"  :> Summary "Node endpoint"
                                       :> Capture "node_id" ContextId
                                       :> NamedRoutes (ContextAPI HyperdataAny)
  , corpusNodeAPI :: mode :- "corpus"  :> Summary "Corpus endpoint"
                                       :> Capture "corpus_id" CorpusId
                                       :> NamedRoutes (NodeAPI HyperdataCorpus)
  , corpusNodeNodeAPI :: mode :- "corpus" :> Summary "Corpus endpoint"
                                          :> Capture "node1_id" NodeId
                                          :> "document"
                                          :> Capture "node2_id" NodeId
                                          :> NamedRoutes (NodeNodeAPI HyperdataAny)
  , corpusExportAPI :: mode :- "corpus" :> Capture "node_id" CorpusId
                                        :> NamedRoutes CorpusExportAPI
  , annuaireEp :: mode :- "annuaire" :> Summary "Annuaire endpoint"
                                     :> Capture "annuaire_id" AnnuaireId
                                     :> NamedRoutes (NodeAPI HyperdataAnnuaire)
  , contactAPI :: mode :- "annuaire" :> Summary "Contact endpoint"
                                     :> Capture "annuaire_id" NodeId
                                     :> NamedRoutes ContactAPI
  , tableNgramsAPI :: mode :- "document" :> Summary "Document endpoint"
                                         :> Capture "doc_id" DocId
                                         :> "ngrams"
                                         :> NamedRoutes TableNgramsAPI
  , documentExportAPI :: mode :- "texts" :> Capture "node_id" DocId
                                         :> NamedRoutes DocumentExportAPI
  , countAPI :: mode :- "count" :> Summary "Count endpoint"
                                :> ReqBody '[JSON] Query
                                :> NamedRoutes CountAPI
  , graphAPI :: mode :- "graph" :> Summary "Graph endpoint"
                                :> Capture "graph_id" NodeId
                                :> NamedRoutes GraphAPI
  , treeAPI :: mode :- "tree" :> Summary "Tree endpoint"
                              :> Capture "tree_id" NodeId
                              :> PolicyChecked (NamedRoutes TreeAPI)
  , treeFlatAPI :: mode :- "treeflat" :> Summary "Flat tree endpoint"
                                      :> Capture "tree_id" NodeId
                                      :> NamedRoutes TreeFlatAPI
  , membersAPI     :: mode :- "members" :> Summary "Team node members" :> NamedRoutes MembersAPI
  , addWithFormEp  :: mode :- NamedRoutes AddWithForm
  , addWithQueryEp :: mode :- NamedRoutes AddWithQuery
  , listGetAPI     :: mode :- NamedRoutes List.GETAPI
  , listJsonAPI    :: mode :- NamedRoutes List.JSONAPI
  , listCsvAPI     :: mode :- NamedRoutes List.CSVAPI
  , shareUrlEp     :: mode :- "shareurl" :> NamedRoutes ShareURL
  } deriving Generic


data GargAdminAPI mode = GargAdminAPI
  { rootsEp       :: mode :- "user"  :> Summary "First user endpoint" :> NamedRoutes Roots
  , adminNodesAPI :: mode :- "nodes" :> Summary "Nodes endpoint"
                                     :> ReqBody '[JSON] [NodeId]
                                     :> NamedRoutes NodesAPI
  } deriving Generic


data NodeEndpoint mode = NodeEndpoint
  { nodeEndpointAPI :: mode :- "node" :> Summary "Node endpoint"
                                      :> Capture "node_id" NodeId
                                      :> NamedRoutes (NodeAPI HyperdataAny)
  } deriving Generic


data MembersAPI mode = MembersAPI
  { getMembersEp :: mode :- Get '[JSON] [Text]
  }

