{-# LANGUAGE TupleSections #-}

module Gargantext.Core.Worker.Broker
  ( initBrokerWithDBCreate )
where

import Async.Worker.Broker.PGMQ (PGMQBroker, BrokerInitParams(PGMQBrokerInitParams))
import Async.Worker.Broker.Types (Broker, initBroker)
import Async.Worker.Types qualified as WorkerT
import Data.Text qualified as T
import Data.Text.Encoding qualified as TE
import Database.PostgreSQL.Simple qualified as PSQL
import Gargantext.Core.Config (GargConfig(..), gc_worker)
import Gargantext.Core.Config.Worker (WorkerSettings(..))
import Gargantext.Core.Worker.Jobs.Types (Job(..))
import Gargantext.Prelude
import Shelly qualified as SH



-- | Create DB if not exists, then run 'initBroker' (which, in
-- particular, creates the pgmq extension, if needed)
initBrokerWithDBCreate :: (WorkerT.HasWorkerBroker PGMQBroker Job)
                       => GargConfig
                       -> IO (Broker PGMQBroker (WorkerT.Job Job))
initBrokerWithDBCreate gc@(GargConfig { _gc_database_config }) = do
  -- By using gargantext db credentials, we create pgmq db (if needed)
  let WorkerSettings { .. }  = gc ^. gc_worker
  let psqlDB = TE.decodeUtf8 $ PSQL.postgreSQLConnectionString _gc_database_config
  -- For the \gexec trick, see:
  -- https://stackoverflow.com/questions/18389124/simulate-create-database-if-not-exists-for-postgresql
  (_res, _ec) <- SH.shelly $ SH.silently $ SH.escaping False $ do
    let sql = "\"SELECT 'CREATE DATABASE " <> (T.pack $ PSQL.connectDatabase _wsDatabase) <> "' WHERE NOT EXISTS (SELECT FROM pg_database WHERE datname = '" <> (T.pack $ PSQL.connectDatabase _wsDatabase) <> "')\\gexec\""
    result <- SH.run "echo" [sql, "|", "psql", "-d", "\"" <> psqlDB <> "\""]
    (result,) <$> SH.lastExitCode

  initBroker $ PGMQBrokerInitParams _wsDatabase _wsDefaultVisibilityTimeout
