{-|
Module      : Gargantext.Core.Worker.Jobs
Description : Worker job definitions
Copyright   : (c) CNRS, 2024
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}


module Gargantext.Core.Worker.Jobs where


import Async.Worker.Broker.PGMQ (PGMQBroker)
import Async.Worker qualified as Worker
import Async.Worker.Types (HasWorkerBroker)
import Control.Lens (view)
import Gargantext.Core.Config (gc_worker, HasConfig(..))
import Gargantext.Core.Config.Worker (WorkerSettings(..), WorkerDefinition(..))
import Gargantext.Core.Worker.Broker (initBrokerWithDBCreate)
import Gargantext.Core.Worker.Jobs.Types (Job(..))
import Gargantext.Database.Prelude (Cmd')
import Gargantext.Prelude


sendJob :: (HasWorkerBroker PGMQBroker Job, HasConfig env)
        => Job
        -> Cmd' env err ()
sendJob job = do
  gcConfig <- view $ hasConfig
  let WorkerSettings { _wsDefinitions } = gcConfig ^. gc_worker
  -- TODO Try to guess which worker should get this job
  -- let mWd = findDefinitionByName ws workerName
  let mWd = head _wsDefinitions
  case mWd of
    Nothing -> panicTrace "No worker definitions available"
    Just wd -> liftBase $ do
      b <- initBrokerWithDBCreate gcConfig
      let queueName = _wdQueue wd
      void $ Worker.sendJob' $ Worker.mkDefaultSendJob' b queueName job
