{-|
Module      : Gargantext.Core.Worker.Jobs.Types
Description : Worker job definitions
Copyright   : (c) CNRS, 2024-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}


module Gargantext.Core.Worker.Jobs.Types where


import Data.Aeson ((.:), (.=), object, withObject)
import Data.Aeson.Types (prependFailure, typeMismatch)
import Gargantext.API.Admin.Auth.Types (AuthenticatedUser, ForgotPasswordAsyncParams)
import Gargantext.API.Admin.EnvTypes ( GargJob )
import Gargantext.API.Node.New.Types ( PostNode(..) )
import Gargantext.API.Node.Types (NewWithForm)
import Gargantext.Core.Types.Individu (User)
import Gargantext.Database.Admin.Types.Node (CorpusId, NodeId)
import Gargantext.Prelude


data Job =
    Ping
  | AddCorpusFormAsync { _acf_args :: NewWithForm
                       , _acf_user :: User
                       , _acf_cid  :: CorpusId }
  | ForgotPasswordAsync { _fpa_args :: ForgotPasswordAsyncParams }
  | NewNodeAsync { _nna_node_id :: NodeId
                 , _nna_authenticatedUser :: AuthenticatedUser
                 , _nna_postNode :: PostNode }
  | GargJob { _gj_garg_job :: GargJob }
  deriving (Show, Eq)
instance FromJSON Job where
  parseJSON = withObject "Job" $ \o -> do
    type_ <- o .: "type"
    case type_ of
      "Ping" -> return Ping
      "AddCorpusFormAsync" -> do
        _acf_args <- o .: "args"
        _acf_user <- o .: "user"
        _acf_cid <- o .: "cid"
        return $ AddCorpusFormAsync { .. }
      "ForgotPasswordAsync" -> do
        _fpa_args <- o .: "args"
        return $ ForgotPasswordAsync { _fpa_args }
      "NewNodeAsync" -> do
        _nna_node_id <- o .: "node_id"
        _nna_authenticatedUser <- o .: "authenticated_user"
        _nna_postNode <- o .: "post_node"
        return $ NewNodeAsync { .. }
      "GargJob" -> do
        _gj_garg_job <- o .: "garg_job"
        return $ GargJob { _gj_garg_job }
      s -> prependFailure "parsing job type failed, " (typeMismatch "type" s)
instance ToJSON Job where
  toJSON Ping = object [ ("type" .= ("Ping" :: Text)) ]
  toJSON (AddCorpusFormAsync { .. }) = object [ ("type" .= ("AddCorpusFormJob" :: Text))
                                              , ("args" .= _acf_args)
                                              , ("user" .= _acf_user)
                                              , ("cid" .= _acf_cid) ]
  toJSON (ForgotPasswordAsync { .. }) = object [ ("type" .= ("ForgotPasswordAsync" :: Text))
                                               , ("args" .= _fpa_args) ]
  toJSON (NewNodeAsync { .. }) = object [ ("type" .= ("NewNodeAsync" :: Text))
                                        , ("node_id" .= _nna_node_id)
                                        , ("authenticated_user" .= _nna_authenticatedUser)
                                        , ("post_node" .= _nna_postNode) ]
  toJSON (GargJob { .. }) = object [ ("type" .= ("GargJob" :: Text))
                                   , ("garg_job" .= _gj_garg_job) ]
