{-# LANGUAGE TypeOperators #-}
{-# LANGUAGE DeriveGeneric #-}
module Gargantext.API.Routes.Named.List where

import Data.Text (Text)
import GHC.Generics
import Gargantext.API.Admin.Orchestrator.Types
import Gargantext.API.Ngrams.List.Types
import Gargantext.API.Ngrams.Types
import Gargantext.API.Types (HTML)
import Gargantext.Database.Admin.Types.Node
import Gargantext.Utils.Servant qualified as GUS
import Servant

newtype GETAPI mode = GETAPI
  { getListEp :: mode :- Summary "Get List"
                      :> "lists"
                      :> Capture "listId" ListId
                      :> ( "json"
                           :> Get '[JSON, HTML] (Headers '[Header "Content-Disposition" Text] NgramsList)
                         :<|>  "json.zip"
                           :> Get '[GUS.ZIP] (Headers '[Header "Content-Disposition" Text] NgramsListZIP)
                         :<|> "csv"
                           :> Get '[GUS.CSV] (Headers '[Header "Content-Disposition" Text] NgramsTableMap) )
  } deriving Generic


newtype JSONAPI mode = JSONAPI
  { updateListJSONEp :: mode :- Summary "Update List"
                             :> "lists"
                             :> Capture "listId" ListId
                             :> "add"
                             :> "form"
                             :> "async"
                             :> AsyncJobs JobLog '[FormUrlEncoded] WithJsonFile JobLog
  } deriving Generic


newtype CSVAPI mode = CSVAPI
  { updateListCSVEp :: mode :- Summary "Update List (legacy v3 CSV)"
                            :> "lists"
                            :> Capture "listId" ListId
                            :> "csv"
                            :> "add"
                            :> "form"
                            :> "async"
                            :> AsyncJobs JobLog '[FormUrlEncoded] WithTextFile JobLog
  } deriving Generic
