{-|
Module      : Upgrade.hs
Description : Gargantext Import Corpus
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

Upgrade a gargantext node.

 -}

{-# LANGUAGE Strict            #-}
{-# LANGUAGE QuasiQuotes       #-}

module CLI.Upgrade where

import CLI.Types
import CLI.Parsers
import Data.List qualified as List (cycle, concat, take, unlines)
import Gargantext.API.Dev (withDevEnv)
import Gargantext.API.Node () -- instances only
import Gargantext.Core.Config (GargConfig(..))
import Gargantext.Core.Config.Types (SecretsConfig(..))
import Gargantext.Core.Config.Utils (readConfig)
import Gargantext.Prelude
import Options.Applicative
import Prelude qualified

upgradeCLI :: UpgradeArgs -> IO ()
upgradeCLI (UpgradeArgs settingsFile) = do

  let ___ = putStrLn ((List.concat
                       $ List.take 72
                       $ List.cycle ["_"]) :: Prelude.String)

  ___
  putStrLn ("GarganText upgrade to version 0.0.6.9.9.4.4" :: Text)
  ___

  putStrLn $ List.unlines
           [ "Your Database defined in gargantext.ini will be upgraded."
           , "We stronlgy recommend you to make a backup using pg_dump."
           , ""
           , "Press ENTER if you want to continue, CTRL+C if you want to stop."
           ]

  _ok  <- getLine

  cfg       <- readConfig settingsFile
  let _secret = _s_secret_key $ _gc_secrets cfg

  withDevEnv settingsFile $ \_env -> do
    -- _ <- runCmdDev env addIndex
    -- _ <- runCmdDev env refreshIndex


    ___
    putStrLn ("Uprade done with success !" :: Text)
    ___
    pure ()

-- refreshIndex :: Cmd'' DevEnv IOException ()
-- refreshIndex = do
--   _ <- execPGSQuery [sql| REFRESH MATERIALIZED VIEW CONCURRENTLY context_node_ngrams_view; |] ()
--   pure ()

-- addIndex :: Cmd'' DevEnv IOException Int64
-- addIndex = do
--   execPGSQuery query ()
--     where
--       query = [sql|
--         CREATE MATERIALIZED VIEW IF NOT EXISTS context_node_ngrams_view AS
--           SELECT DISTINCT context_node_ngrams.context_id, ngrams_id, nodes_contexts.node_id
--           FROM nodes_contexts
--           JOIN context_node_ngrams
--           ON context_node_ngrams.context_id = nodes_contexts.context_id;

--         CREATE INDEX IF NOT EXISTS context_node_ngrams_context_id_ngrams_id_idx
--           ON context_node_ngrams(context_id, ngrams_id);

--         CREATE INDEX IF NOT EXISTS context_node_ngrams_view_context_id_idx
--           ON context_node_ngrams_view(context_id);
--         CREATE INDEX IF NOT EXISTS context_node_ngrams_view_ngrams_id_idx
--           ON context_node_ngrams_view(ngrams_id);
--         CREATE INDEX IF NOT EXISTS context_node_ngrams_view_node_id_idx
--           ON context_node_ngrams_view(node_id);
--         CREATE UNIQUE INDEX IF NOT EXISTS context_node_ngrams_view_context_ngrams_node_uniq_idx
--           ON context_node_ngrams_view (context_id, ngrams_id, node_id);

--         CREATE INDEX IF NOT EXISTS node_stories_ngrams_id_idx
--           ON node_stories(ngrams_id);
--   |]

upgradeCmd :: HasCallStack => Mod CommandFields CLI
upgradeCmd = command "upgrade" (info (helper <*> fmap CLISub upgrade_p) (progDesc "Upgrade a Gargantext node."))

upgrade_p :: Parser CLICmd
upgrade_p = fmap CCMD_upgrade $ UpgradeArgs
  <$> settings_p
