{-# LANGUAGE TemplateHaskell   #-}
module Gargantext.API.Admin.Settings.MicroServices where

import Prelude

import Control.Lens.TH
import Data.Text qualified as T
import Gargantext.Core.Config
import Servant.Client.Core.BaseUrl
import Toml

data MicroServicesSettings =
  MicroServicesSettings {
    -- | The port where the microservices proxy will be listening on.
    _msProxyPort    :: !Int
  , _msProxyEnabled :: !Bool
  } deriving (Show, Eq)

microServicesSettingsCodec :: TomlCodec MicroServicesSettings
microServicesSettingsCodec = MicroServicesSettings
  <$> Toml.int  "port"    .= _msProxyPort
  <*> Toml.bool "enabled" .= _msProxyEnabled

mkProxyUrl :: GargConfig -> MicroServicesSettings -> BaseUrl
mkProxyUrl GargConfig{..} MicroServicesSettings{..} =
  case parseBaseUrl (T.unpack _gc_url) of
    Nothing -> BaseUrl Http "localhost" 80 ""
    Just bh -> bh { baseUrlPort = _msProxyPort }


makeLenses ''MicroServicesSettings
