{-# LANGUAGE TypeApplications #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE QuasiQuotes #-}

module Test.Offline.Database (tests) where

import Gargantext.Database.Admin.Config (nodeTypes)
import Prelude
import Test.Tasty
import Test.Tasty.QuickCheck
import qualified Data.Bimap as Bimap
import qualified Data.Set as Set

tests :: TestTree
tests = testGroup "Database" [
    testProperty "NodeType -> NodeTypeId no clashes" nodeTypesNoClashing_prop
  ]

-- | Tests that the 'nodeTypes' bimap never yields clashing IDs, i.e.
-- different keys yielding the same value.
nodeTypesNoClashing_prop :: Property
nodeTypesNoClashing_prop =
  let e = Bimap.elems nodeTypes
  in counterexample "Careful! the nodeTypes bimap has clashing values!" $
       Set.toList (Set.fromList e) === e

