{-|
Module      : Gargantext.Core.NodeStory.Utils
Description : NodeStory utilities
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

module Gargantext.Core.NodeStory.Utils
  ( saveNodeStory )
where

import Control.Lens (view)
import Gargantext.Core.NodeStory
import Gargantext.Core.Types (NodeId)
import Gargantext.Prelude



saveNodeStory :: ( MonadReader env m, MonadBase IO m, HasNodeStoryImmediateSaver env )
              => NodeId -> ArchiveList -> m ()
saveNodeStory nId a = do
  saver <- view hasNodeStoryImmediateSaver
  liftBase $ saver nId a
