{-|
Module      : Gargantext.Core.Text.Corpus.Parsers.Types
Description : Parsers types
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

module Gargantext.Core.Text.Corpus.Parsers.Types where

import Data.Aeson
import Data.Swagger
import Gargantext.Prelude
import Test.QuickCheck (elements)
import Test.QuickCheck.Arbitrary (Arbitrary, arbitrary)



-- | According to the format of Input file,
-- different parser are available.
data FileType = CsvGargV3
              | CsvHal
              | Iramuteq
              | Istex
              | JSON
              | RIS
              | RisPresse
              | WOS
  deriving (Show, Eq, Generic)
instance ToSchema FileType
instance Arbitrary FileType where arbitrary = elements [ CsvGargV3
                                                       , RisPresse]
instance ToParamSchema FileType
instance FromJSON FileType
instance ToJSON FileType


data FileFormat =
    Plain
  | ZIP
  deriving (Show, Eq, Generic)
instance ToSchema FileFormat
instance Arbitrary FileFormat where arbitrary = elements [ Plain
                                                         , ZIP ]
instance ToParamSchema FileFormat
instance FromJSON FileFormat
instance ToJSON FileFormat


