{-|
Module      : Gargantext.Core.Text.Corpus.Types
Description : Types for text scraping
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

module Gargantext.Core.Text.Corpus.Types
where


import Data.Aeson
import Data.Swagger hiding (URL, url, port)
import GHC.Generics hiding (to)
import Gargantext.Prelude
import Test.QuickCheck.Arbitrary

-- | Main Types
-- TODO IsidoreAuth
data ExternalAPIs = Arxiv
                  | EPO
                  | HAL
                  | IsTex
                  | Isidore
                  | OpenAlex
                  | PubMed
  deriving (Show, Eq, Generic, Enum, Bounded)

-- | Main Instances
instance FromJSON ExternalAPIs
instance ToJSON ExternalAPIs

externalAPIs :: [ExternalAPIs]
externalAPIs = [minBound .. maxBound]

instance Arbitrary ExternalAPIs
  where
    arbitrary = arbitraryBoundedEnum

instance ToSchema ExternalAPIs where
  declareNamedSchema = genericDeclareNamedSchemaUnrestricted defaultSchemaOptions

