{-| Module      : Graph.BAC.Types
Description : 
Copyright   : (c) CNRS, Alexandre Delanoë
License     : AGPL (MIT) + CECILL (CEA/CNRS/INRIA)
Maintainer  : alexandre+dev@delanoe.org
Stability   : experimental
Portability : POSIX

-}

{-# LANGUAGE TemplateHaskell       #-}
{-# LANGUAGE MultiParamTypeClasses #-}
{-# LANGUAGE NoImplicitPrelude #-}

module Graph.BAC.Types
  where

import Data.Serialize
import Data.Monoid
import Control.Lens
import Graph.FGL hiding (Graph)
import Protolude
import qualified Data.Serialize       as S
import qualified Data.Graph.Inductive as DGI
import qualified Data.Set             as Set


instance Serialize Text where
  put txt = S.put $ encodeUtf8 txt
  get     = fmap decodeUtf8 S.get
---------------------------------------------------------------
-- | Data Main Types
---------------------------------------------------------------
type Module      = Set Node   -- Module can not be empty
data Module' score = Module' { _mod_score :: score
                             , _mod_data  :: Set Node
                             }

type Clustering  = Set Module -- Not Used but for comprehension

type LModule     = Set (DGI.LNode [Text])
type LClustering = Set LModule

-- | Data Contenents
-- Map = Dict (in Python)
type Confluence   = Map (Node, Node) Double
type Confluence'  = Map Node (Map Node Double) -- TODO
{-
type Confluence'' = Confluence'' { graph' :: Graph
                                 , conf  :: Confluence
                                 }
-}
-- ^ when ' TODO with optimization
---------------------------------------------------------------
-- | Main scores Types
---------------------------------------------------------------
type SumConf     = Double
type QualityConf = Double

type Scoring    = Confluence -> Module -> Double
type Scoring' a = Confluence -> Module -> a

type ScoringClustering  = Confluence -> Set Module -> Double -- Score
type ScoringClustering' a = Confluence -> Set Module -> a

-------
class HasScore score t where
  hasScore    :: (DGI.DynGraph gr, Serialize label, Ord label)
              => gr label Double -> Confluence -> t -> score
  updateScore :: (DGI.DynGraph gr, Serialize label, Ord label)
              => gr label Double -> Confluence -> score -> t -> t -> score

class TestScore a b where
  testScore    :: Confluence -> a -> b -> b -> Bool
  testScore'   :: Confluence -> a -> b -> b -> Bool
  testScore''  :: Confluence -> a -> b -> b -> Bool
  testScore''' :: Confluence -> a -> b -> b -> Bool

class HasData mod clustering where
  updateData :: clustering -> mod -> mod -> clustering

class CanSearch node mod where
  search :: node -> Set mod -> mod


-------

instance HasData Module Clustering where
  updateData c m1 m2 = Set.insert (Set.union m1 m2)
                     $ Set.delete m1
                     $ Set.delete m2 c

---------------------------------------------------------------
data Kern score a = Kern { _kern_score :: score
                         , _kern_data  :: a
                         }
  deriving (Show, Eq, Ord)

instance (Monoid score, Monoid a) => Monoid (Kern score a)
  where
    mempty = Kern mempty mempty

instance (Semigroup score, Semigroup a) => Semigroup (Kern score a)
  where
    (<>) (Kern s1 a1)
         (Kern s2 a2) = Kern (s1 <> s2)
                             (a1 <> a2)

-- TODO: check if + or * or else
instance Semigroup Double where
  (<>) d1 d2 = d1 + d2


data Kerns score a = Kerns { _kerns_score :: score
                           , _kerns_data  :: [Kern score a]
                           }
  deriving (Show, Eq, Ord)

---------------------------------------------------------------
makeLenses ''Kern
makeLenses ''Kerns


