{-| Module      : Graph.Clustering
Description : 
Copyright   : (c) CNRS, Alexandre Delanoë
License     : AGPL (MIT) + CECILL (CEA/CNRS/INRIA)
Maintainer  : alexandre+dev@delanoe.org
Stability   : experimental
Portability : POSIX

Reference: Article POK de QuaC de G
POK: Parts Overlap Kern
-}

{-# LANGUAGE NoImplicitPrelude #-}

module Graph.BAC.Test
  where

import Protolude
import Data.Text (pack)
import Graph.BAC.Clustering
import Graph.FGL hiding (Graph)
import qualified Data.List                         as List
import qualified Data.Graph.Inductive              as DGI
import qualified Data.Graph.Inductive.PatriciaTree as DGIP

-------------------------------------------------
graph_0 = mkLGraphfromEdges [(1,1,1)]

clusterGraph_test = clusterGraph 3 graph_0

{-
   ___
  |   |
  |_1_|

clusterGraph_test1 = (clusterGraph 3 (mkGraphUfromEdges [(1,1)]))
  == Kerns 0.0 (ks<>ks) -- this is a bug : duplicate due to reflexivity
    where
      ks = [Kern 0 (Set.singleton (Set.singleton 1))]
-}


clusterGraph_test2 = clusterGraph 3 (mkLGraphfromEdges [(1,1,1),(1,2,1)])
{-
    1---2

-- Bug duplicate + Bug score

-- Kerns {bestScore = 0.0
         , allkerns = [Kern {score = 0.0, kern = fromList [fromList [1,2]]}
                      ,Kern {score = 0.0, kern = fromList [fromList [1],fromList [2]]}
                      ,Kern {score = 0.0, kern = fromList [fromList [1],fromList [2]]}
                      ]
         }
-}

clusterGraph_test2' = clusterGraph 3 (mkLGraphfromEdges [(1,2,1)])
{- 
Bug scores should be different here: 1 for global clustering ?
    1---2
  Kerns {bestScore = 0.0
         ,allkerns = [Kern {score = 0.0, kern = fromList [fromList [1,2]]}
                     ,Kern {score = 0.0, kern = fromList [fromList [1],fromList [2]]}
                     ]
         }
-}

{-

    1----2-----4----5
     \  /       \   /
      \/         \ /
      3           6

 clusterGraph_test6
Kerns
    { bestScore = 0.4702888443638837
    , allkerns =
        [ Kern
            { score = 0.4702888443638837
            , kern = fromList
                [ fromList
                    [ 1
                    , 2
                    , 3
                    ]
                , fromList
                    [ 4
                    , 5
                    , 6
                    ]
                ]
            }
          ]

Bug: should have Set.fromList [ Set.fromList [1,2,3], Set.fromList [4,5,6]]
-}

g4 :: [(Node,Node,Double)]
g4 = [(0,1,1)
     ,(1,2,1)
     ,(2,0,1)
     ,(2,3,1) -- Example différent avec les autres algos
     ]

g5 = [(3,4,1)
     ,(4,5,1)
     ,(5,3,1)  -- Double cuiller
--           ,(5,6,1)  -- Double cuiller avec pendant
--           ,(6,7,1)  -- Vers la triple cuiller
--                ,(4,6,1)
           ]
--                ,(5,6,1)
--                ,(6,7,1)
--                ,(7,1,1)


g_doubleCuiller = g4 <> g5

g_papillon :: [(Node,Node,Double)]
g_papillon = aile1 <> aile2
  where
    aile1 = [(0,1,1)
            ,(1,2,1)
            ,(2,0,1)
            ]

    aile2 = [(2,3,1)
            ,(3,4,1)
            ,(4,2,1)
            ]

g_bizarre :: [(Node,Node,Double)]
g_bizarre = [(0,1,1),(1,2,1),(2,3,1),(3,0,1),(3,4,1)]

graph :: DGI.DynGraph gr => [(Node,Node,Double)] -> gr [Text] Double
graph es = DGI.mkGraph ns es
  where
    ns = map (\n -> (n, [pack (show n)])) [0..n-1]
    n  = List.length $ List.nub $ List.concat $ map (\(n1,n2,_) -> [n1,n2]) es


g_toy :: [(Node,Node,Double)]
g_toy = [(0,1,1)
        ,(0,2,1)
        ,(0,3,1)
        ,(0,4,1)
        ,(0,5,1)
        ,(0,6,1)
        ,(1,2,1)
        ,(1,3,1)
        ,(2,3,1)
        ,(2,8,1)
        ,(3,7,1)
        ,(4,5,1)
        ,(4,6,1)
        ,(4,7,1)
        ,(5,6,1)
        ,(5,8,1)
        ,(7,8,1)
--        ,(9,2,1)
--        ,(9,4,1)
        ]

--------------------

lconf_doubleCuiller :: [(Int, Int, Double)]
lconf_doubleCuiller = [(0, 1, 0.16883116883116886), (4, 5, 0.16883116883116886), (3, 5, 0.07692307692307693), (3, 4, 0.07692307692307693), (0, 2, 0.0769230769230769), (1, 2, 0.0769230769230769), (2, 3, -1.0)]




