{-# LANGUAGE TypeApplications #-}
{-| Module      : Graph.Tools
Description :
Copyright   : (c) CNRS, Alexandre Delanoë
License     : AGPL + CECILL v3
Maintainer  : alexandre+dev@delanoe.org
Stability   : experimental
Portability : POSIX


-}

{-# LANGUAGE GADTs #-}
{-# LANGUAGE ConstraintKinds #-}
{-# LANGUAGE InstanceSigs    #-}
{-# LANGUAGE NoImplicitPrelude       #-}


{-# LANGUAGE ScopedTypeVariables #-}
module Graph.Tools.Import where

import Data.Csv
import Data.Text (pack, splitOn, unpack)
import Data.Vector hiding (map, uniq)
import Prelude (read)
import Protolude
import Graph.Types
import Graph.Tools.Random
import Graph.Tools.CSV
import Graph.FGL
import qualified Data.Matrix.Sparse.Static as SMatrix
import qualified Data.IntMap          as Dict
import qualified Data.Map             as Map
import qualified Data.ByteString.Lazy as BL
import qualified Data.Graph.Inductive as Graph
import qualified Data.List            as List
import qualified Data.Set             as Set
import qualified Data.Vector          as Vector
import Data.Reflection
import qualified Data.IntMap.Strict as IntMap

------------------------------------------------------------------------
data GetGraph a b where
  WithFile :: { filepath :: FilePath } -> GetGraph [Text] Double
  Random   :: Int -> GetGraph () ()

data GraphData a b where
  LightGraph
    :: { lightGraph :: Graph () () } -> GraphData () ()
  LabelledGraph
    :: { labelledGraph :: Graph [Text] Double } -> GraphData [Text] Double


getGraph' :: FileGraph -> GetGraph a b-> IO (GraphData a b)
getGraph' _ (Random n) = reifyNat (fromIntegral n) $ \(pn :: Proxy n) ->
  randomAdjacency @n
                >>= \m -> pure $ LightGraph
                               $ mkGraphUfromEdges
                               $ List.map (\(x,y,_) -> (x,y))
                               $ SMatrix.toList m

getGraph' fg (WithFile fp) = do
  g <- readFileGraph fg fp
  pure $ LabelledGraph g


getGraph :: FileGraph -> GetGraph a b -> IO (Graph a b)
getGraph fg gg = toGraph' <$> getGraph' fg gg

toGraph' :: GraphData a b -> Graph a b
toGraph' (LightGraph    g) = g
toGraph' (LabelledGraph g) = g
