{-|
Module      : Gargantext.Prelude.Crypto.Hash
Description : Useful Tools near Prelude of the project
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

{-# OPTIONS_GHC -fno-warn-orphans   #-}

module Gargantext.Prelude.Crypto.Hash
  where

import Data.ByteString.Lazy.Char8 qualified as Char
import Data.Digest.Pure.SHA qualified as SHA (sha256, showDigest)
import Data.Set (Set)
import Data.Set qualified as Set
import Data.Text (Text)
import Data.Text qualified as Text
import Gargantext.Prelude hiding (Ordering, hash)
import Prelude (String)

--------------------------------------------------------------------------
-- | Use this datatype to keep traceability of hashes
-- TODO use newtype
type Hash = Text

-- | Class to make hashes
class IsHashable a where
  hash :: a -> Hash

-- | Main API to hash text
-- using sha256 for now
instance IsHashable Char.ByteString where
  hash = Text.pack
        . SHA.showDigest
        . SHA.sha256

instance {-# OVERLAPPING #-} IsHashable String where
  hash = hash . Char.pack

instance IsHashable Text where
  hash = hash . Text.unpack


instance IsHashable (Set Hash) where
  hash = hash . foldl (<>) "" . Set.toList

instance {-# OVERLAPPABLE #-} IsHashable a => IsHashable [a] where
  hash = hash . Set.fromList . map hash
