{-|
Module      : Gargantext.Prelude.Crypto.Auth
Description :
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

module Gargantext.Prelude.Crypto.QRCode where

import Data.Maybe
import Protolude ((<$>), Int)
import Codec.QRCode (encode, ToText)
import Data.Text.Internal.Lazy (Text)
import Codec.QRCode.Data.ErrorLevel (ErrorLevel(H))
import Codec.QRCode.Data.QRCodeOptions (defaultQRCodeOptions)
import Codec.QRCode.JuicyPixels
import Codec.QRCode (QRCodeOptions, TextEncoding(Utf8WithECI))


qrCode :: ToText a => Int -> a -> Maybe Text
qrCode size a = toPngDataUrlT size size
             <$> encode (defaultQRCodeOptions H) Utf8WithECI a

