{-|
Module      : Gargantext.Prelude.Mail
Description :
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

module Gargantext.Prelude.Mail
  (gargMail, GargMail(..), readConfig)
  where

-- import Data.Text.Internal.Lazy (Text)
import Data.Text (Text, unpack)
import Data.Maybe
import Network.Mail.SMTP hiding (htmlPart, STARTTLS)
import Gargantext.Prelude
import Gargantext.Prelude.Config (readIniFile', val)
import Gargantext.Prelude.Mail.Types (LoginType(..), MailConfig(..))
import Network.Mail.Mime (plainPart)
import Prelude (read)
import System.IO (FilePath)


type Email = Text
type Name  = Text

readConfig :: FilePath -> IO MailConfig
readConfig fp = do
  ini <- readIniFile' fp
  let val' = val ini "mail"

  pure $ MailConfig { _mc_mail_host       =        cs $ val' "MAIL_HOST"
                    , _mc_mail_port       = read $ cs $ val' "MAIL_PORT"
                    , _mc_mail_user       =        cs $ val' "MAIL_USER"
                    , _mc_mail_from       =        cs $ val' "MAIL_FROM"
                    , _mc_mail_password   =        cs $ val' "MAIL_PASSWORD"
                    , _mc_mail_login_type = read $ cs $ val' "MAIL_LOGIN_TYPE"
                    }


data GargMail = GargMail { gm_to      :: Email
                         , gm_name    :: Maybe Name
                         , gm_subject :: Text
                         , gm_body    :: Text
                         }

-- | TODO add parameters to gargantext.ini
gargMail :: MailConfig -> GargMail -> IO ()
gargMail (MailConfig {..}) (GargMail { .. }) = do
  let host     = unpack _mc_mail_host
      user     = unpack _mc_mail_user
      password = unpack _mc_mail_password
  case _mc_mail_login_type of
    NoAuth   -> sendMail                   host mail
    Normal   -> sendMailWithLogin'         host _mc_mail_port user password mail
    SSL      -> sendMailWithLoginTLS'      host _mc_mail_port user password mail
    TLS      -> sendMailWithLoginTLS'      host _mc_mail_port user password mail
    STARTTLS -> sendMailWithLoginSTARTTLS' host _mc_mail_port user password mail
  where
    mail = simpleMail from to cc bcc gm_subject [plainPart $ cs gm_body]

    from     = Address (Just "GarganText Email") _mc_mail_from
    to       = [Address gm_name gm_to]
    cc       = []
    bcc      = []
