{-|
Module      : Gargantext.Prelude.Mail.Types
Description : Textmining Collaborative Platform
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

{-# LANGUAGE TemplateHaskell     #-}

module Gargantext.Prelude.Mail.Types where

import Control.Lens (makeLenses)
import qualified Data.Text as T
import GHC.Generics (Generic)
import Network.Socket (PortNumber)
import Protolude

data LoginType = NoAuth | Normal | SSL | TLS | STARTTLS
  deriving (Generic, Eq, Show, Read)

data MailConfig = MailConfig { _mc_mail_host         :: !T.Text
                             , _mc_mail_port         :: !PortNumber
                             , _mc_mail_user         :: !T.Text
                             , _mc_mail_password     :: !T.Text
                             , _mc_mail_login_type   :: !LoginType
                             , _mc_mail_from         :: !T.Text
                             }
  deriving (Generic, Show)

makeLenses ''MailConfig
