{-|
Module      : Gargantext.Prelude.NLP
Description :
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

module Gargantext.Prelude.NLP
  (NLPConfig(..), readConfig)
  where

import qualified Data.Ini as Ini
import qualified Data.Map.Strict as Map
import Data.Text (Text, unpack)
import qualified Data.Text as T
import Data.Maybe
import Gargantext.Prelude
import Gargantext.Prelude.Config (readIniFile', val)
import Gargantext.Prelude.NLP.Types (NLPConfig(..))
import Gargantext.Prelude.Utils (listToMaybeAll)
import Network.URI (parseURI)
import Protolude hiding (show)
import System.IO (FilePath)


type URL = Text

iniSection :: Text
iniSection = "nlp"

readConfig :: FilePath -> IO NLPConfig
readConfig fp = do
  ini <- readIniFile' fp
  let val' = val ini iniSection

  let m_nlp_all = parseURI $ cs $ val' "All"

  let m_nlp_keys = filter (\k -> k `notElem` ["All"]) $ fromRight [] $ Ini.keys iniSection ini
  let m_nlp_other = listToMaybeAll $ (\k -> (,) k <$> (parseURI $ cs $ val' k)) <$> m_nlp_keys

  let mRet = NLPConfig <$> m_nlp_all <*> (Map.fromList <$> m_nlp_other)

  case mRet of
    Nothing -> panic $ T.concat [ "Cannot read config file: _nlp_all = "
                                , T.pack $ show m_nlp_all
                                , ", _nlp_other = "
                                , T.pack $ show m_nlp_other ]
    Just ret -> pure ret
