{-|
Module      : Gargantext.Prelude.NLP.Types
Description : Textmining Collaborative Platform
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

{-# LANGUAGE TemplateHaskell     #-}

module Gargantext.Prelude.NLP.Types where

import Control.Lens (makeLenses)
import qualified Data.Map.Strict as Map
import qualified Data.Text as T
import GHC.Generics (Generic)
import Network.Socket (PortNumber)
import Network.URI (URI)
import Protolude

data NLPConfig = NLPConfig { _nlp_all   :: URI
                           , _nlp_languages :: (Map.Map T.Text URI) }
  deriving (Generic, Show)

makeLenses ''NLPConfig
