{-|
Module      : Gargantext.API.Node.Get
Description :
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

Polymorphic Get Node API

-}

module Gargantext.API.Node.Get
      where

import Data.Aeson
import Data.Swagger (ToSchema)
import Gargantext.Database.Admin.Types.Node (NodeId, NodeType)
import Gargantext.Prelude

------------------------------------------------------------------------
data GetNodeParams = GetNodeParams { node_id  :: NodeId 
                                   , nodetype :: NodeType
                                   }
    deriving (Generic)

------------------------------------------------------------------------
instance FromJSON  GetNodeParams where
  parseJSON = genericParseJSON (defaultOptions { sumEncoding = ObjectWithSingleField })

instance ToJSON    GetNodeParams where
  toJSON = genericToJSON (defaultOptions { sumEncoding = ObjectWithSingleField })
  
instance ToSchema  GetNodeParams

------------------------------------------------------------------------
