{-|
Module      : Gargantext.API.Routes.Named.Annuaire
Description : Annuaire API routes
Copyright   : (c) CNRS, 2024-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

{-# LANGUAGE TypeOperators #-}

module Gargantext.API.Routes.Named.Annuaire (
  -- * Routes types
    AddAnnuaireWithForm(..)
  ) where

import GHC.Generics (Generic)
import Gargantext.API.Node.Corpus.Annuaire (AnnuaireWithForm)
import Gargantext.API.Worker (WorkerAPI)
import Gargantext.Database.Admin.Types.Node (AnnuaireId)
import Servant

newtype AddAnnuaireWithForm mode = AddAnnuaireWithForm
  { addWithFormEp :: mode :- Summary "Add with FormUrlEncoded to annuaire endpoint"
                          :> "annuaire"
                          :> Capture "annuaire_id" AnnuaireId
                          :> "add"
                          :> "form"
                          :> "async"
                          :> NamedRoutes (WorkerAPI '[FormUrlEncoded] AnnuaireWithForm)
  } deriving Generic
