{-# LANGUAGE TypeOperators #-}
{-# LANGUAGE DeriveGeneric #-}
module Gargantext.API.Routes.Named.Contact (
  -- * Routes types
    ContactAPI(..)
  , ContactAsyncAPI(..)

  -- * API types (appears in the routes)
  , AddContactParams(..)
  ) where


import Data.Text (Text)
import GHC.Generics
import Gargantext.API.Admin.Orchestrator.Types
import Gargantext.API.Routes.Named.Node (NodeNodeAPI(..))
import Gargantext.Database.Admin.Types.Hyperdata.Contact
import Gargantext.Database.Admin.Types.Node
import Servant


data ContactAPI mode = ContactAPI
  { contactAsyncAPI :: mode :- "contact" :> Summary "Contact endpoint" :> NamedRoutes ContactAsyncAPI
  , getContactEp    :: mode :- Capture "contact_id" NodeId :> NamedRoutes (NodeNodeAPI HyperdataContact)
  } deriving Generic


newtype ContactAsyncAPI mode = ContactAsyncAPI
  { addContactAsyncEp :: mode :- AsyncJobs JobLog '[JSON] AddContactParams JobLog
  } deriving Generic


data AddContactParams = AddContactParams         { firstname :: !Text, lastname :: !Text }
                      | AddContactParamsAdvanced { firstname :: !Text
                                                 , lastname  :: !Text
                                                 -- TODO add others fields
                                                 }
    deriving Generic
