{-# LANGUAGE OverloadedStrings #-}
{-# LANGUAGE TemplateHaskell   #-}
module Gargantext.API.Admin.Settings.MicroServices where

import Prelude

import Toml
import Control.Lens.TH

data MicroServicesSettings =
  MicroServicesSettings {
    -- | The port where the microservices proxy will be listening on.
    _msProxyPort :: Int
  } deriving (Show, Eq)

microServicesSettingsCodec :: TomlCodec MicroServicesSettings
microServicesSettingsCodec = MicroServicesSettings
  <$> Toml.int "proxy-port" .= _msProxyPort

makeLenses ''MicroServicesSettings
