{-# LANGUAGE DerivingStrategies #-}
{-# LANGUAGE StandaloneDeriving #-}

{-|
Module      : Gargantext.Core.Worker.Types
Description : Some useful worker types
Copyright   : (c) CNRS, 2024-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

module Gargantext.Core.Worker.Types where

import Async.Worker.Broker.PGMQ (PGMQBroker)
import Async.Worker.Broker.Types qualified as BT
import Data.Aeson ((.=), (.:), object, withObject)
import Data.Swagger (NamedSchema(..), ToSchema(..))  -- , genericDeclareNamedSchema)
import Gargantext.Core.Types (NodeId)
import Gargantext.Prelude


data JobInfo = JobInfo { _ji_message_id :: BT.MessageId PGMQBroker
                       -- NOTE: Most jobs are associated with node id.
                       -- The 'node_id' allows the frontend to assign progress bar to a node.
                       , _ji_mNode_id     :: Maybe NodeId } 
  deriving (Show, Eq, Ord, Generic)
instance ToSchema JobInfo where -- TODO
  --declareNamedSchema = genericDeclareNamedSchema (unPrefixSwagger "_ji_")
  declareNamedSchema _ = do
    return $ NamedSchema (Just "JobInfo") $ mempty
instance FromJSON JobInfo where
  parseJSON = withObject "JobInfo" $ \o -> do
    _ji_message_id <- o .: "message_id"
    _ji_mNode_id <- o .: "node_id"
    pure $ JobInfo { .. }
instance ToJSON JobInfo where
  toJSON (JobInfo { .. }) = object [ "message_id" .= _ji_message_id 
                                   , "node_id"    .= _ji_mNode_id ]
instance NFData JobInfo
