{-# OPTIONS_GHC -freduction-depth=400 #-}

{-|
Module      : Gargantext.API.Swagger
Description : Swagger API generation
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

---------------------------------------------------------------------
module Gargantext.API.Swagger where
---------------------------------------------------------------------
import Control.Lens ((?~))
import Data.Swagger
import Data.Version (showVersion)
import Gargantext.API.Routes.Named qualified as Named
import Gargantext.Prelude
import Paths_gargantext qualified as PG -- cabal magic build module
import Servant
import Servant.Swagger (toSwagger, subOperations)

backendApiProxy :: Proxy (ToServantApi Named.BackEndAPI)
backendApiProxy = Proxy

-- | Swagger Specifications
swaggerDoc :: Swagger
swaggerDoc = toSwagger backendApiProxy
  & info.title       .~ "GarganText"
  & info.version     .~ (cs $ showVersion PG.version)
  -- & info.base_url     ?~ (URL "http://gargantext.org/")
  & info.description ?~ "REST API specifications"
  -- & tags             .~ Set.fromList [Tag "Garg" (Just "Main perations") Nothing]
  & applyTagsFor (subOperations backendApiProxy backendApiProxy)
                 ["Gargantext" & description ?~ "Main operations"]
  & info.license     ?~ ("AGPLV3 (English) and CECILL (French)" & url ?~ URL urlLicence )
    where
        urlLicence = "https://gitlab.iscpif.fr/gargantext/haskell-gargantext/blob/master/LICENSE"
