{-|
Module      : Gargantext.Core.Worker.PGMQTypes
Description : Worker type aliases for PGMQ
Copyright   : (c) CNRS, 2024-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

{-# LANGUAGE ConstraintKinds #-}


module Gargantext.Core.Worker.PGMQTypes where

import Async.Worker.Broker.PGMQ (PGMQBroker)
import Async.Worker.Broker.Types qualified as BT
import Async.Worker qualified as W
import Async.Worker.Types qualified as W
import Gargantext.Core.Worker.Jobs.Types (Job)


type HasWorkerBroker = W.HasWorkerBroker PGMQBroker Job
type Broker = BT.Broker PGMQBroker (W.Job Job)
type BrokerMessage = BT.BrokerMessage PGMQBroker (W.Job Job)
type MessageId = BT.MessageId PGMQBroker
type SendJob = W.SendJob PGMQBroker Job
type WState = W.State PGMQBroker Job
