{ fetchFromGitLab,
  fetchpatch,
  graphviz }:
let
  graphviz_dev = graphviz.overrideAttrs (finalAttrs: previousAttrs: {
    version = "11.0.0~dev";
    src = fetchFromGitLab {
      owner = "graphviz";
      repo = "graphviz";
      rev = "f3ec849249ef9cb824feb7f97449d7159e1dcb4e"; # head as of 2024-03-25, see gargantext#329
      hash = "sha256-s86IqWz6zeKbcRqpV3cVQBVviHbhUSX1U8GVuJBfjC4=";
    };
  });
in
graphviz_dev.overrideAttrs
  (finalAttrs: previousAttrs: {
    # Increase the YY_BUF_SIZE, see https://gitlab.iscpif.fr/gargantext/haskell-gargantext/issues/290#note_9015
    patches = [
      (fetchpatch {
        url = "https://gist.githubusercontent.com/adinapoli/e93ca7b1d714d27f4af537716b03e3bb/raw/b9cc297c3465878da2d18ee92a3f9b8273923493/graphviz-yy-buf-size.patch";
        sha256 = "sha256-8Q3tf37iYaPV50P+Vf/n263ordECiu5eKwONCy3ynV8=";
      })
    ];
  })
