{-|
Module      : Gargantext.API.Node.Corpus.New.Types
Description :
Copyright   : (c) CNRS, 2017
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX
-}

module Gargantext.API.Node.Corpus.New.Types where

import Data.Swagger (ToSchema, ToParamSchema)
import Data.Text (pack)
import Gargantext.Prelude
import Servant

data FileType = TSV
              | TSV_HAL
              | Istex
              | PresseRIS
              | WOS
              | Iramuteq
              | JSON
  deriving (Eq, Show, Generic)
instance ToSchema FileType
instance ToParamSchema FileType
instance FromJSON FileType
instance ToJSON FileType

instance FromHttpApiData FileType where
  parseUrlPiece "TSV"       = pure TSV
  parseUrlPiece "TSV_HAL"   = pure TSV_HAL
  parseUrlPiece "Istex"     = pure Istex
  parseUrlPiece "PresseRis" = pure PresseRIS
  parseUrlPiece "WOS"       = pure WOS
  parseUrlPiece "Iramuteq"  = pure Iramuteq
  parseUrlPiece "JSON"      = pure JSON
  parseUrlPiece s           = panicTrace $ "[G.A.A.Node.Corpus.New] File Type not implemented (yet): " <> s
instance ToHttpApiData FileType where
  toUrlPiece = pack . show

data FileFormat = Plain | ZIP
  deriving (Eq, Show, Generic)
instance ToSchema FileFormat
instance ToParamSchema FileFormat
instance FromJSON FileFormat
instance ToJSON FileFormat
instance FromHttpApiData FileFormat where
  parseUrlPiece "Plain" = pure Plain
  parseUrlPiece "ZIP"   = pure ZIP
  parseUrlPiece _       = pure Plain -- TODO error here
instance ToHttpApiData FileFormat where
  toUrlPiece = pack . show
