{-# LANGUAGE ViewPatterns      #-}
{-# LANGUAGE OverloadedStrings #-}
{-# LANGUAGE LambdaCase #-}
{-# LANGUAGE ScopedTypeVariables #-}

module Gargantext.API.Server.Named.Remote (
  remoteAPI
  ) where

import Codec.Serialise
import Conduit
import Control.Lens (view)
import Data.ByteString.Builder qualified as B
import Data.ByteString.Char8 qualified as C8
import Data.ByteString.Lazy qualified as BL
import Data.Conduit.Combinators qualified as C
import Data.Conduit.List qualified as CL
import Gargantext.API.Prelude (IsGargServer)
import Gargantext.API.Routes.Client (remoteImportClient)
import Gargantext.API.Routes.Named.Remote qualified as Named
import Gargantext.Core.Config
import Prelude
import Servant.Client.Streaming (mkClientEnv, withClientM, ClientError)
import Servant.Server.Generic (AsServerT)

remoteAPI :: (MonadIO m, IsGargServer env err m) => Named.RemoteAPI (AsServerT m)
remoteAPI = Named.RemoteAPI $
  Named.RemoteAPI'
    { remoteExportEp = remoteExportHandler
    , remoteImportEp = pure
    }

type ExpectedPayload = C8.ByteString -- FIXME(adn)

remoteImportHandler :: (MonadIO m, Serialise a) => ConduitT () Named.RemoteBinaryData IO () -> m a
remoteImportHandler c = liftIO $ do
  chunks <- sourceToList $ c .| C.map (B.byteString . Named.getRemoteBinaryData)
  case deserialiseOrFail (B.toLazyByteString $ mconcat chunks) of
    Left err    -> liftIO $ error $ "Deserialization error: " ++ show err
    Right value -> pure value

remoteExportHandler :: ( MonadIO m
                       , IsGargServer err env m
                       )
                    => Named.RemoteExportRequest
                    -> m ()
remoteExportHandler Named.RemoteExportRequest{..} = do
  mgr  <- view gargHttpManager
  -- FIXME(adn) eventually we want to be sending nodes here.
  let node = C8.pack "hello world"
  result <- liftIO $ withClientM (remoteImportClient _rer_instance_auth (streamEncoder node)) (mkClientEnv mgr _rer_instance_url) streamDecode
  liftIO $ putStrLn (show (result :: ExpectedPayload))

streamEncoder :: Serialise a => a -> ConduitT () Named.RemoteBinaryData IO ()
streamEncoder = CL.sourceList . map Named.RemoteBinaryData . BL.toChunks . serialise

streamDecode :: Either ClientError (ConduitT () Named.RemoteBinaryData IO ()) -> IO ExpectedPayload
streamDecode = \case
  Left err -> error $ show err -- FIXME(adn) How to deal with the error properly?
  Right c  -> remoteImportHandler c
