{-# LANGUAGE TypeOperators #-}

module Gargantext.API.Routes.Named.FrameCalc (
  -- * Routes types
    FrameCalcAPI(..)
  ) where

import Servant
import GHC.Generics
import Gargantext.API.Node.FrameCalcUpload.Types (FrameCalcUpload)
import Gargantext.API.Worker (WorkerAPI)


newtype FrameCalcAPI mode = FrameCalcAPI
  { frameCalcUploadEp :: mode :- Summary " FrameCalc upload"
                              :> "add"
                              :> "framecalc"
                              :> "async"
                              :> NamedRoutes (WorkerAPI '[JSON] FrameCalcUpload)
  } deriving Generic

