{ fetchFromGitHub,

  igraph,

  arpack,
  blas,
  glpk,
  gmp,
  lapack,
  libxml2,
  nanomsg,
  plfit,
  llvmPackages,
  
  version ? "0.10.4",
  hash ? "sha256-LsTOxUktGZcp46Ec9QH3+9C+VADMYTZZCjKF1gp36xk=" }:

igraph.overrideAttrs (finalAttrs: previousAttrs: {
  inherit version;

  nativeBuildInputs = previousAttrs.nativeBuildInputs;

  src = fetchFromGitHub {
    inherit hash;
    owner = "igraph";
    repo = "igraph";
    rev = version;
  };

  postPatch = ''
    echo "${version}" > IGRAPH_VERSION
  '';

  outputs = [ "dev" "out" "doc" ];

  buildInputs = [
    arpack
    blas
    glpk
    gmp
    lapack
    libxml2
    nanomsg
    plfit
    llvmPackages.openmp
  ];

  cmakeFlags = [
    "-DIGRAPH_USE_INTERNAL_BLAS=OFF"
    "-DIGRAPH_USE_INTERNAL_LAPACK=OFF"
    "-DIGRAPH_USE_INTERNAL_ARPACK=OFF"
    "-DIGRAPH_USE_INTERNAL_GLPK=OFF"
    "-DIGRAPH_USE_INTERNAL_GMP=OFF"
    "-DIGRAPH_USE_INTERNAL_PLFIT=OFF"
    "-DIGRAPH_GLPK_SUPPORT=ON"
    "-DIGRAPH_GRAPHML_SUPPORT=OFF"
    "-DIGRAPH_OPENMP_SUPPORT=ON"
    "-DIGRAPH_ENABLE_LTO=AUTO"
    "-DIGRAPH_ENABLE_TLS=ON"
    "-DBUILD_SHARED_LIBS=ON"
    "-DCMAKE_INSTALL_PREFIX=${placeholder "out"}"
    "-DCMAKE_INSTALL_LIBDIR=${placeholder "out"}/lib"
    "-DCMAKE_INSTALL_DATADIR=${placeholder "out"}/share"
  ];

  doCheck = false;

  postInstall = ''
    mkdir -p "$out/share"
    cp -r doc "$out/share"
  '';

  postFixup = previousAttrs.postFixup + ''
    echo "Copying files where they belong .."
    CUR_DIR=$PWD
    cd "$dev/include/igraph" && cp *.h ../
    cd $CUR_DIR
  '';

})
