{-|
Module      : Gargantext.Core.Text.Corpus.Parsers.TSV.TSVv4
Description :
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

module Gargantext.Core.Text.Corpus.Parsers.TSV.TSVv4 where

import Data.Csv
-- import Gargantext.Core.Utils.DateUtils qualified as DateUtils
-- import Gargantext.Core.Text.Corpus.Parsers.TSV.IntOrDec
import Gargantext.Database.Admin.Types.Hyperdata.Document ( HyperdataDocument(..) )
import Gargantext.Prelude



data TsvGargV4 = TsvGargV4
    { d_docId             :: !Int
    , d_title             :: !Text
    , d_source            :: !Text
    , d_publication_date  :: !Text
    , d_abstract          :: !Text
    , d_authors           :: !Text
    }
    deriving (Show)



data TsvDoc = TsvDoc
    { tsv_title             :: !Text
    , tsv_source            :: !Text
    , tsv_publication_date  :: !Text
    , tsv_abstract          :: !Text
    , tsv_authors           :: !Text
    }
    deriving (Show)



instance FromNamedRecord TsvDoc where
  parseNamedRecord r = do
    tsv_title <- r .: "Title"
    tsv_source <- r .: "Source"
    tsv_publication_date <- r .: "Publication Date"
    tsv_abstract <- r .: "Abstract"
    tsv_authors <- r .: "Authors"
    pure $ TsvDoc { .. }

instance DefaultOrdered TsvDoc where
  headerOrder _ = header [ "Publication Date"
                         , "Authors"
                         , "Title"
                         , "Source"
                         , "Abstract"]

instance ToNamedRecord TsvDoc where
  toNamedRecord (TsvDoc{ .. }) =
    namedRecord [ "Title"             .= tsv_title
                , "Source"            .= tsv_source
                , "Publication Date"  .= tsv_publication_date
                , "Abstract"          .= tsv_abstract
                , "Authors"           .= tsv_authors
                ]


doc2tsv :: HyperdataDocument -> TsvDoc
doc2tsv h = TsvDoc { tsv_title = m $ _hd_title h
                                    , tsv_source = m $ _hd_source h
                                    , tsv_publication_date = m $ _hd_publication_date h
                                    , tsv_abstract = m $ _hd_abstract h
                                    , tsv_authors = m $ _hd_authors h }

  where
    m = maybe "" identity
