{-|
Module      : Gargantext.Core.Text.Corpus.Parsers.TSV.TsvIsidore
Description :
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

module Gargantext.Core.Text.Corpus.Parsers.TSV.TsvIsidore where

import Data.Csv
import Gargantext.Core.Text.Corpus.Parsers.TSV.IntOrDec
import Gargantext.Database.Admin.Types.Hyperdata.Document ( HyperdataDocument(..) )
import Gargantext.Prelude


headerIsidore :: Header
headerIsidore =
  header [ "title"
         , "source"
         , "publication_year"
         , "publication_month"
         , "publication_day"
         , "abstract"
         , "authors"
         ]

data TsvDoc = TsvDoc
    { tsv_title             :: !Text
    , tsv_source            :: !Text
    , tsv_publication_year  :: !(Maybe IntOrDec)
    , tsv_publication_month :: !(Maybe Int)
    , tsv_publication_day   :: !(Maybe Int)
    , tsv_abstract          :: !Text
    , tsv_authors           :: !Text
    }
    deriving (Show)

instance ToNamedRecord TsvDoc where
  toNamedRecord (TsvDoc{ .. }) =
    namedRecord [ "title"             .= tsv_title
                , "source"            .= tsv_source
                , "publication_year"  .= tsv_publication_year
                , "publication_month" .= tsv_publication_month
                , "publication_day"   .= tsv_publication_day
                , "abstract"          .= tsv_abstract
                , "authors"           .= tsv_authors
                ]


doc2tsv :: HyperdataDocument -> TsvDoc
doc2tsv h = TsvDoc { tsv_title = m $ _hd_title h
                   , tsv_source = m $ _hd_source h
                   , tsv_publication_year = Just $ IntOrDec $ mI $ _hd_publication_year h
                   , tsv_publication_month = Just $ mI $ _hd_publication_month h
                   , tsv_publication_day = Just $ mI $ _hd_publication_day   h
                   , tsv_abstract = m $ _hd_abstract h
                   , tsv_authors = m $ _hd_authors h }

  where
    m = maybe "" identity
    mI = maybe 0 identity

