{-|
Module      : Gargantext.Core.Text.Corpus.Parsers.TSV.TsvPhylo
Description :
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}


module Gargantext.Core.Text.Corpus.Parsers.TSV.TsvPhylo where

import Data.Csv
import Gargantext.Prelude

------------------------------------------------------------------------
-- Tsv v3 weighted for phylo

data Tsv' = Tsv'
      { tsv'_title             :: !Text
      , tsv'_source            :: !Text
      , tsv'_publication_year  :: !Int
      , tsv'_publication_month :: !Int
      , tsv'_publication_day   :: !Int
      , tsv'_abstract          :: !Text
      , tsv'_authors           :: !Text
      , tsv'_weight            :: !Double } deriving (Show)


instance FromNamedRecord Tsv' where
  parseNamedRecord r = do
    tsv'_title <- r .: "title"
    tsv'_source <- r .: "source"
    tsv'_publication_year <- r .: "publication_year"
    tsv'_publication_month <- r .: "publication_month"
    tsv'_publication_day <- r .: "publication_day"
    tsv'_abstract <- r .: "abstract"
    tsv'_authors <- r .: "authors"
    tsv'_weight <- r .: "weight"
    pure $ Tsv' { .. }
