{-# LANGUAGE TemplateHaskell  #-}

module Gargantext.Core.Text.Corpus.Parsers.TSV.Types where

import Data.Csv (DecodeOptions(..), EncodeOptions(..), defaultDecodeOptions, defaultEncodeOptions)
import Data.Csv.Incremental qualified as CSVI
import Gargantext.Prelude


-- | Little helper data structure to make working with the incremental
-- TSV parsing a bit nicer.
data ParsingContext a
  = MkHeaderParsingContext (CSVI.HeaderParser (CSVI.Parser a))
  | MkRecordParsingContext (RecordParsingContext a)
  deriving Show

data RecordParsingContext a = RecordParsingContext
  { -- Either the header parser, if we just started parsing the document, or actual
    -- incremental parser for the records.
    -- This field will contain 'Nothing' if the parser has been drained and we need
    -- to stop recursion.
    _prs_ctx_parser         :: Maybe (CSVI.Parser a)
  , _prs_ctx_parsed_records :: [a]
  -- | Keeps track of the current row we are in, so that we can insert proper error
  -- diagnostics.
  , _prs_ctx_row_cursor     :: !Int
  } deriving Show

makeLenses ''RecordParsingContext



data Delimiter = Tab | Comma | Line deriving (Eq, Show)

tsvDecodeOptions :: Delimiter -> DecodeOptions
tsvDecodeOptions d = defaultDecodeOptions {decDelimiter = delimiter d}

tsvEncodeOptions :: Delimiter -> EncodeOptions
tsvEncodeOptions d = defaultEncodeOptions {encDelimiter = delimiter d}

delimiter :: Delimiter -> Word8
delimiter Tab   = fromIntegral $ ord '\t'
delimiter Comma = fromIntegral $ ord ','
delimiter Line  = fromIntegral $ ord '\n'

