{-|
Module      : Gargantext.API.Node.File.Types
Description :
Copyright   : (c) CNRS, 2017
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX
-}

module Gargantext.API.Node.File.Types where

import Data.ByteString qualified as BS
import Data.ByteString.Lazy qualified as BSL
import Data.Swagger (ToSchema(..))
import Gargantext.Core.Types (TODO)
import Gargantext.Database.GargDB qualified as GargDB
import Gargantext.Prelude
import Network.HTTP.Media qualified as M
import Servant


data RESPONSE deriving Typeable

instance Accept RESPONSE where
  contentType _ = "text" M.// "*"
instance MimeRender RESPONSE BSResponse where
  mimeRender _ (BSResponse val) = BSL.fromStrict $ val
instance MimeUnrender RESPONSE BSResponse where
  mimeUnrender _ lbs = Right $ BSResponse (BSL.toStrict lbs)

newtype Contents = Contents BS.ByteString
instance GargDB.ReadFile Contents where
  readFile' fp = do
    c <- BS.readFile fp
    pure $ Contents c
instance ToSchema Contents where
  declareNamedSchema _ = declareNamedSchema (Proxy :: Proxy TODO)
instance MimeUnrender OctetStream Contents where
  mimeUnrender _ lbs = Right $ Contents (BSL.toStrict lbs)

newtype BSResponse = BSResponse BS.ByteString
  deriving (Generic)
instance ToSchema BSResponse  where
  declareNamedSchema _ = declareNamedSchema (Proxy :: Proxy TODO)


-- | Temporary file, held in database, return it's OID
newtype DBTempFile = DBTempFile Int
  deriving (Generic, ToJSON)
instance ToSchema DBTempFile  where
  declareNamedSchema _ = declareNamedSchema (Proxy :: Proxy TODO)
