{-|
Module      : Gargantext.Core.Text.Corpus.Parsers.TSV
Description :
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

TSV parser for Gargantext corpus files.

-}


module Gargantext.Core.Text.Corpus.Parsers.TSV (
    readTSVFile
  , readTSVFileDelim
  , Delimiter(..)
  , parseTsv
  , parseTsvC
  , tsvDecodeOptions
  , writeDocs2Tsv
  , parseHal
  , readTsvHal
  , TsvHal(..)
  -- * Used in tests
  , testCorrectFile
  , testErrorPerLine
  , validTextField
  , validNumber
  , getHeaders
  , findDelimiter
  , delimiter
  -- * Used in the main executables
  , defaultDay
  , defaultYear
  , fromMIntOrDec
  , defaultMonth
  ) where

import Gargantext.Core.Text.Corpus.Parsers.TSV.Diagnostics
import Gargantext.Core.Text.Corpus.Parsers.TSV.IntOrDec
import Gargantext.Core.Text.Corpus.Parsers.TSV.TsvHal
import Gargantext.Core.Text.Corpus.Parsers.TSV.Types
import Gargantext.Core.Text.Corpus.Parsers.TSV.Utils


