{-|
Module      : Gargantext.Core.Text.Corpus.Parsers.TSV.TSVv4
Description :
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

module Gargantext.Core.Text.Corpus.Parsers.TSV.TSVv4 where

import Data.Csv
-- import Gargantext.Core.Text.Corpus.Parsers.TSV.IntOrDec
import Gargantext.Database.Admin.Types.Hyperdata.Document ( HyperdataDocument(..) )
import Gargantext.Prelude


headerTsvGargV4 :: Header
headerTsvGargV4 =
  header [ "title"
         , "source"
         , "publication_year"
         , "publication_month"
         , "publication_day"
         , "abstract"
         , "authors"
         ]

data TsvGargV4 = TsvGargV4
    { d_docId             :: !Int
    , d_title             :: !Text
    , d_source            :: !Text
    , d_publication_date  :: !Text
    , d_abstract          :: !Text
    , d_authors           :: !Text
    }
    deriving (Show)



data TsvDoc = TsvDoc
    { tsv_title             :: !Text
    , tsv_source            :: !Text
    , tsv_publication_date  :: !Text
    , tsv_abstract          :: !Text
    , tsv_authors           :: !Text
    }
    deriving (Show)



instance FromNamedRecord TsvDoc where
  parseNamedRecord r = do
    tsv_title <- r .: "title" <|> r .: "Title"
    tsv_source <- r .: "source" <|> r .: "Source"
    tsv_publication_date <- r .: "publication_date" <|> r .: "Publication Date"
    tsv_abstract <- r .: "abstract" <|> r .: "Abstract"
    tsv_authors <- r .: "authors" <|> r .: "Authors"
    pure $ TsvDoc { .. }

instance ToNamedRecord TsvDoc where
  toNamedRecord (TsvDoc{ .. }) =
    namedRecord [ "title"             .= tsv_title
                , "source"            .= tsv_source
                , "publication_date"  .= tsv_publication_date
                , "abstract"          .= tsv_abstract
                , "authors"           .= tsv_authors
                ]


hyperdataDocument2tsvDoc :: HyperdataDocument -> TsvDoc
hyperdataDocument2tsvDoc h = TsvDoc { tsv_title = m $ _hd_title h
                                    , tsv_source = m $ _hd_source h
                                    , tsv_publication_date = m $ _hd_publication_date h
                                    , tsv_abstract = m $ _hd_abstract h
                                    , tsv_authors = m $ _hd_authors h }

  where
    m = maybe "" identity
