{-# LANGUAGE TemplateHaskell     #-}

module Gargantext.API.Admin.Types where

import Control.Lens
import GHC.Enum
import Gargantext.Prelude
import Servant.Auth.Server (CookieSettings(..))
import Servant.Client (BaseUrl)



data SendEmailType = SendEmailViaAws
                   | LogEmailToConsole
                   | WriteEmailToFile
    deriving (Show, Read, Enum, Bounded, Generic)

data Settings = Settings
    { 
--    , _dbServer        :: Text
--    ^ this is not used yet
      _cookieSettings        :: !CookieSettings
    , _sendLoginEmails       :: !SendEmailType
    , _scrapydUrl            :: !BaseUrl
    }

makeLenses ''Settings

class HasSettings env where
  settings :: Getter env Settings

instance HasSettings Settings where
  settings = identity

data FireWall = FireWall { unFireWall :: Bool }
