{-|
Module      : Test.Core.Worker
Description :
Copyright   : (c) CNRS, 2024-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

module Test.Core.Worker where

import Data.Aeson qualified as Aeson
import Gargantext.Core.Worker.Jobs.Types (Job(..))
import Gargantext.Prelude
import Test.Instances ()
import Test.Hspec
import Test.Hspec.QuickCheck



tests :: Spec
tests = describe "worker unit tests" $
    prop "Worker Job to/from JSON serialization is correct" $
      \job -> Aeson.decode (Aeson.encode (job :: Job)) == Just job

  -- , testProperty "JobInfo to/from JSON serialization is correct" $
  --     \ji -> Aeson.decode (Aeson.encode (ji :: JobInfo)) == Just ji
