{-# LANGUAGE TypeOperators #-}

module Gargantext.API.Routes.Named.Tree (
  -- * Routes types
    NodeTreeAPI(..)
  , TreeFlatAPI(..)
  ) where

import Data.Text (Text)
import GHC.Generics (Generic)
import Gargantext.Core.Types.Main
import Gargantext.Database.Admin.Types.Node (NodeType)
import Servant

data NodeTreeAPI mode = NodeTreeAPI
  { nodeTreeEp   :: mode :- QueryParams "type" NodeType :> Get '[JSON] (Tree NodeTree)
  , firstLevelEp :: mode :- "first-level" :> QueryParams "type" NodeType :> Get '[JSON] (Tree NodeTree)
  } deriving Generic


data TreeFlatAPI mode = TreeFlatAPI
  { getNodesEp :: mode :- QueryParams "type" NodeType :> QueryParam "query" Text :> Get '[JSON] [NodeTree]
  } deriving Generic
