{-|
Module      : Core.Phylo
Description :
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

module Test.Core.Phylo where

import Gargantext.Core.Utils.DateUtils (UTCTimeR(..))
import Gargantext.Core.Viz.Phylo.API.Tools (toMonths, toDays, toHours)
import Gargantext.Prelude
import Test.Hspec
import Test.Instances ()


-- | Core.Utils tests
test :: Spec
test = do
  describe "phylo tools works" $ do
    it "toMonths works" $ do
      toMonths 2025 1 1 `shouldBe` 24300
      toMonths 2025 2 1 `shouldBe` 24301
      toMonths 2025 4 1 `shouldBe` 24303
    it "toDays works" $ do
      toDays 2025 1 1 `shouldBe` 739617
      toDays 2025 1 2 `shouldBe` 739618
      toDays 2025 1 4 `shouldBe` 739620
    it "toHours works" $ do
      toHours (UTCTimeR { year = 2025, month = 1, day = 1, hour = 0, minute = 0, sec = 0 }) `shouldBe` 17742024
      toHours (UTCTimeR { year = 2025, month = 1, day = 1, hour = 1, minute = 0, sec = 0 }) `shouldBe` 17742025
      toHours (UTCTimeR { year = 2025, month = 1, day = 1, hour = 3, minute = 0, sec = 0 }) `shouldBe` 17742027
