module Gargantext.API.Node.Corpus.New.Types where

import Data.Aeson
import Data.Swagger
import Data.Text (pack)
import Gargantext.Prelude
import Servant
import Test.QuickCheck (elements)
import Test.QuickCheck.Arbitrary (Arbitrary, arbitrary)

data FileType = TSV
              | TSV_HAL
              | Istex
              | PresseRIS
              | WOS
              | Iramuteq
              | JSON
  deriving (Eq, Show, Generic)
instance ToSchema FileType
instance Arbitrary FileType where arbitrary = elements [TSV, PresseRIS]
instance ToParamSchema FileType
instance FromJSON FileType
instance ToJSON FileType

instance FromHttpApiData FileType where
  parseUrlPiece "TSV"       = pure TSV
  parseUrlPiece "TSV_HAL"   = pure TSV_HAL
  parseUrlPiece "Istex"     = pure Istex
  parseUrlPiece "PresseRis" = pure PresseRIS
  parseUrlPiece "WOS"       = pure WOS
  parseUrlPiece "Iramuteq"  = pure Iramuteq
  parseUrlPiece "JSON"      = pure JSON
  parseUrlPiece s           = panicTrace $ "[G.A.A.Node.Corpus.New] File Type not implemented (yet): " <> s
instance ToHttpApiData FileType where
  toUrlPiece = pack . show

data FileFormat = Plain | ZIP
  deriving (Eq, Show, Generic)
instance ToSchema FileFormat
instance Arbitrary FileFormat where arbitrary = elements [ Plain, ZIP ]
instance ToParamSchema FileFormat
instance FromJSON FileFormat
instance ToJSON FileFormat
instance FromHttpApiData FileFormat where
  parseUrlPiece "Plain" = pure Plain
  parseUrlPiece "ZIP"   = pure ZIP
  parseUrlPiece _       = pure Plain -- TODO error here
instance ToHttpApiData FileFormat where
  toUrlPiece = pack . show
