{-|
Module      : Core.Notifications
Description :
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

module Test.Core.Notifications
  ( test
  , qcTests )
where

import Data.Aeson qualified as A
import Gargantext.Core.Notifications.CentralExchange.Types
import Gargantext.Core.Notifications.Dispatcher.Types
import Gargantext.Prelude
import Test.Hspec
import Test.Instances ()
import Test.Hspec.QuickCheck


test :: Spec
test = do
  describe "check if json serialization of CEMessage works" $ do
    it "UpdateTreeFirstLevel serialization" $ do
      let ce = UpdateTreeFirstLevel 15
      A.decode (A.encode ce) `shouldBe` (Just ce)

qcTests :: Spec
qcTests =
  describe "Notifications QuickCheck tests" $ do
    prop "CEMessage aeson encoding" $ \m -> A.decode (A.encode (m :: CEMessage)) == Just m
    prop "Topic aeson encoding" $ \t -> A.decode (A.encode (t :: Topic)) == Just t
    prop "WSRequest aeson encoding" $ \ws -> A.decode (A.encode (ws :: WSRequest)) == Just ws
